/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSessionRequestTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalSessionRequestTest.class);
    public static final int CONNECTION_TIMEOUT = 4000;
    private final QuorumBase qb = new QuorumBase();

    @Before
    public void setUp() throws Exception {
        LOG.info("STARTING quorum {}", (Object)this.getClass().getName());
        this.qb.localSessionsEnabled = true;
        this.qb.localSessionsUpgradingEnabled = true;
        this.qb.setUp();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum {}", (Object)this.getClass().getName());
        this.qb.tearDown();
    }

    @Test
    public void testLocalSessionsOnFollower() throws Exception {
        this.testOpenCloseSession(false);
    }

    @Test
    public void testLocalSessionsOnLeader() throws Exception {
        this.testOpenCloseSession(true);
    }

    private void validateRequestLog(long sessionId, int peerId) {
        String session = Long.toHexString(sessionId);
        LOG.info("Searching for txn of session 0x " + session + " on peer " + peerId);
        String peerType = peerId == this.qb.getLeaderIndex() ? "leader" : "follower";
        QuorumPeer peer = this.qb.getPeerList().get(peerId);
        ZKDatabase db = peer.getActiveServer().getZKDatabase();
        for (Leader.Proposal p : db.getCommittedLog()) {
            Assert.assertFalse((String)("Should not see " + Request.op2String((int)p.request.type) + " request from local session 0x" + session + " on the " + peerType), (p.request.sessionId == sessionId ? 1 : 0) != 0);
        }
    }

    public void testOpenCloseSession(boolean onLeader) throws Exception {
        int leaderIdx = this.qb.getLeaderIndex();
        Assert.assertFalse((String)"No leader in quorum?", (leaderIdx == -1 ? 1 : 0) != 0);
        int followerIdx = (leaderIdx + 1) % 5;
        int testPeerIdx = onLeader ? leaderIdx : followerIdx;
        int verifyPeerIdx = onLeader ? followerIdx : leaderIdx;
        String[] hostPorts = this.qb.hostPort.split(",");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        DisconnectableZooKeeper client = new DisconnectableZooKeeper(hostPorts[testPeerIdx], 4000, watcher);
        watcher.waitForConnected(4000L);
        long localSessionId1 = client.getSessionId();
        client.dontReconnect();
        client.disconnect();
        watcher.reset();
        TestableZooKeeper zk = this.qb.createClient(watcher, hostPorts[testPeerIdx], 4000);
        watcher.waitForConnected(4000L);
        long localSessionId2 = zk.getSessionId();
        zk.close();
        watcher.reset();
        Thread.sleep(8000L);
        this.validateRequestLog(localSessionId1, verifyPeerIdx);
        this.validateRequestLog(localSessionId2, verifyPeerIdx);
        this.qb.shutdownServers();
    }
}

