/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.sc;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainer;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerService;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerServiceFactory;
import org.apache.bookkeeper.stream.storage.impl.routing.RoutingHeaderProxyInterceptor;
import org.apache.bookkeeper.stream.storage.impl.sc.Channel404;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StorageContainerImpl
implements StorageContainer {
    private static final Logger log = LoggerFactory.getLogger(StorageContainerImpl.class);
    private final String containerName;
    private final StorageContainerService service;
    private final long scId;
    private final Server grpcServer;
    private volatile Channel channel = Channel404.of();

    StorageContainerImpl(StorageContainerServiceFactory serviceFactory, long scId) {
        this.scId = scId;
        this.service = serviceFactory.createStorageContainerService(scId);
        this.containerName = "container-" + scId;
        this.grpcServer = StorageContainerImpl.buildGrpcServer(this.containerName, this.service.getRegisteredServices());
    }

    private static Server buildGrpcServer(String serverName, Collection<ServerServiceDefinition> services) {
        InProcessServerBuilder builder = InProcessServerBuilder.forName((String)serverName);
        services.forEach(service -> {
            InProcessServerBuilder cfr_ignored_0 = (InProcessServerBuilder)builder.addService(service);
        });
        return ((InProcessServerBuilder)builder.directExecutor()).build();
    }

    public long getId() {
        return this.scId;
    }

    public CompletableFuture<StorageContainer> start() {
        log.info("Starting storage container ({}) ...", (Object)this.getId());
        return this.service.start().thenCompose(ignored -> {
            try {
                this.grpcServer.start();
                log.info("Successfully started storage container ({}).", (Object)this.getId());
                this.channel = ((InProcessChannelBuilder)((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)this.containerName).usePlaintext().directExecutor()).intercept(new ClientInterceptor[]{new RoutingHeaderProxyInterceptor()})).build();
                return FutureUtils.value((Object)this);
            }
            catch (IOException e) {
                log.error("Failed to start the grpc server for storage container ({})", (Object)this.getId(), (Object)e);
                return FutureUtils.exception((Throwable)e);
            }
        });
    }

    public CompletableFuture<Void> stop() {
        log.info("Stopping storage container ({}) ...", (Object)this.getId());
        Channel existingChannel = this.channel;
        this.channel = Channel404.of();
        if (null != existingChannel && existingChannel instanceof ManagedChannel) {
            ((ManagedChannel)existingChannel).shutdown();
        }
        if (null != this.grpcServer) {
            this.grpcServer.shutdown();
        }
        return this.service.stop().thenApply(ignored -> {
            log.info("Successfully stopped storage container ({}).", (Object)this.getId());
            return null;
        });
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void close() {
        this.stop().join();
    }
}

