/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.ClientSslContextProviderFactory;
import io.grpc.xds.internal.sds.ReferenceCountingMap;
import io.grpc.xds.internal.sds.ServerSslContextProviderFactory;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;

public final class TlsContextManagerImpl
implements TlsContextManager {
    private static TlsContextManagerImpl instance;
    private final ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> mapForClients;
    private final ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> mapForServers;

    @VisibleForTesting
    public TlsContextManagerImpl(Bootstrapper bootstrapper) {
        this(new ClientSslContextProviderFactory(bootstrapper), new ServerSslContextProviderFactory(bootstrapper));
    }

    @VisibleForTesting
    TlsContextManagerImpl(ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> clientFactory, ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider> serverFactory) {
        Preconditions.checkNotNull(clientFactory, (Object)"clientFactory");
        Preconditions.checkNotNull(serverFactory, (Object)"serverFactory");
        this.mapForClients = new ReferenceCountingMap<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider>(clientFactory);
        this.mapForServers = new ReferenceCountingMap<EnvoyServerProtoData.DownstreamTlsContext, SslContextProvider>(serverFactory);
    }

    public static synchronized TlsContextManagerImpl getInstance() {
        if (instance == null) {
            instance = new TlsContextManagerImpl(Bootstrapper.getInstance());
        }
        return instance;
    }

    @Override
    public SslContextProvider findOrCreateServerSslContextProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        return this.mapForServers.get(downstreamTlsContext);
    }

    @Override
    public SslContextProvider findOrCreateClientSslContextProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        return this.mapForClients.get(upstreamTlsContext);
    }

    @Override
    public SslContextProvider releaseClientSslContextProvider(SslContextProvider clientSslContextProvider) {
        Preconditions.checkNotNull((Object)clientSslContextProvider, (Object)"clientSslContextProvider");
        return this.mapForClients.release(clientSslContextProvider.getUpstreamTlsContext(), clientSslContextProvider);
    }

    @Override
    public SslContextProvider releaseServerSslContextProvider(SslContextProvider serverSslContextProvider) {
        Preconditions.checkNotNull((Object)serverSslContextProvider, (Object)"serverSslContextProvider");
        return this.mapForServers.release(serverSslContextProvider.getDownstreamTlsContext(), serverSslContextProvider);
    }
}

