/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.admin.CommandResponse;
import org.apache.zookeeper.server.admin.Commands;
import org.apache.zookeeper.server.quorum.BufferStats;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CommandsTest
extends ClientBase {
    public void testCommand(String cmdName, Map<String, String> kwargs, Field ... fields) throws IOException, InterruptedException {
        ZooKeeperServer zks = this.serverFactory.getZooKeeperServer();
        Map result = Commands.runCommand((String)cmdName, (ZooKeeperServer)zks, kwargs).toMap();
        Assert.assertTrue((boolean)result.containsKey("command"));
        Assert.assertEquals((Object)cmdName, result.remove("command"));
        Assert.assertTrue((boolean)result.containsKey("error"));
        Assert.assertNull((String)("error: " + result.get("error")), result.remove("error"));
        for (Field field : fields) {
            String k = field.key;
            Assert.assertTrue((String)("Result from command " + cmdName + " missing field \"" + k + "\"\n" + result), (boolean)result.containsKey(k));
            Class<?> t = field.type;
            Object v = result.remove(k);
            Assert.assertTrue((String)("\"" + k + "\" field from command " + cmdName + " should be of type " + t + ", is actually of type " + v.getClass()), (boolean)t.isAssignableFrom(v.getClass()));
        }
        Assert.assertTrue((String)("Result from command " + cmdName + " contains extra fields: " + result), (boolean)result.isEmpty());
    }

    public void testCommand(String cmdName, Field ... fields) throws IOException, InterruptedException {
        this.testCommand(cmdName, new HashMap<String, String>(), fields);
    }

    @Test
    public void testConfiguration() throws IOException, InterruptedException {
        this.testCommand("configuration", new Field("client_port", Integer.class), new Field("data_dir", String.class), new Field("data_log_dir", String.class), new Field("tick_time", Integer.class), new Field("max_client_cnxns", Integer.class), new Field("min_session_timeout", Integer.class), new Field("max_session_timeout", Integer.class), new Field("server_id", Long.class), new Field("client_port_listen_backlog", Integer.class));
    }

    @Test
    public void testConnections() throws IOException, InterruptedException {
        this.testCommand("connections", new Field("connections", Iterable.class), new Field("secure_connections", Iterable.class));
    }

    @Test
    public void testObservers() throws IOException, InterruptedException {
        this.testCommand("observers", new Field("synced_observers", Integer.class), new Field("observers", Iterable.class));
    }

    @Test
    public void testObserverConnectionStatReset() throws IOException, InterruptedException {
        this.testCommand("observer_connection_stat_reset", new Field[0]);
    }

    @Test
    public void testConnectionStatReset() throws IOException, InterruptedException {
        this.testCommand("connection_stat_reset", new Field[0]);
    }

    @Test
    public void testDump() throws IOException, InterruptedException {
        this.testCommand("dump", new Field("expiry_time_to_session_ids", Map.class), new Field("session_id_to_ephemeral_paths", Map.class));
    }

    @Test
    public void testEnvironment() throws IOException, InterruptedException {
        this.testCommand("environment", new Field("zookeeper.version", String.class), new Field("host.name", String.class), new Field("java.version", String.class), new Field("java.vendor", String.class), new Field("java.home", String.class), new Field("java.class.path", String.class), new Field("java.library.path", String.class), new Field("java.io.tmpdir", String.class), new Field("java.compiler", String.class), new Field("os.name", String.class), new Field("os.arch", String.class), new Field("os.version", String.class), new Field("user.name", String.class), new Field("user.home", String.class), new Field("user.dir", String.class), new Field("os.memory.free", String.class), new Field("os.memory.max", String.class), new Field("os.memory.total", String.class));
    }

    @Test
    public void testGetTraceMask() throws IOException, InterruptedException {
        this.testCommand("get_trace_mask", new Field("tracemask", Long.class));
    }

    @Test
    public void testIsReadOnly() throws IOException, InterruptedException {
        this.testCommand("is_read_only", new Field("read_only", Boolean.class));
    }

    @Test
    public void testLastSnapshot() throws IOException, InterruptedException {
        this.testCommand("last_snapshot", new Field("zxid", String.class), new Field("timestamp", Long.class));
    }

    @Test
    public void testMonitor() throws IOException, InterruptedException {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(new Field("version", String.class), new Field("avg_latency", Double.class), new Field("max_latency", Long.class), new Field("min_latency", Long.class), new Field("packets_received", Long.class), new Field("packets_sent", Long.class), new Field("num_alive_connections", Integer.class), new Field("outstanding_requests", Long.class), new Field("server_state", String.class), new Field("znode_count", Integer.class), new Field("watch_count", Integer.class), new Field("ephemerals_count", Integer.class), new Field("approximate_data_size", Long.class), new Field("open_file_descriptor_count", Long.class), new Field("max_file_descriptor_count", Long.class), new Field("last_client_response_size", Integer.class), new Field("max_client_response_size", Integer.class), new Field("min_client_response_size", Integer.class), new Field("uptime", Long.class), new Field("global_sessions", Long.class), new Field("local_sessions", Long.class), new Field("connection_drop_probability", Double.class), new Field("outstanding_tls_handshake", Integer.class)));
        Map<String, Object> metrics = MetricsUtils.currentServerMetrics();
        for (String metric : metrics.keySet()) {
            boolean alreadyDefined = fields.stream().anyMatch(f -> f.key.equals(metric));
            if (alreadyDefined) continue;
            if (metric.startsWith("avg_")) {
                fields.add(new Field(metric, Double.class));
                continue;
            }
            fields.add(new Field(metric, Long.class));
        }
        Field[] fieldsArray = fields.toArray(new Field[0]);
        this.testCommand("monitor", fieldsArray);
    }

    @Test
    public void testRuok() throws IOException, InterruptedException {
        this.testCommand("ruok", new Field[0]);
    }

    @Test
    public void testServerStats() throws IOException, InterruptedException {
        this.testCommand("server_stats", new Field("version", String.class), new Field("read_only", Boolean.class), new Field("server_stats", ServerStats.class), new Field("node_count", Integer.class), new Field("client_response", BufferStats.class));
    }

    @Test
    public void testSetTraceMask() throws IOException, InterruptedException {
        HashMap<String, String> kwargs = new HashMap<String, String>();
        kwargs.put("traceMask", "1");
        this.testCommand("set_trace_mask", kwargs, new Field("tracemask", Long.class));
    }

    @Test
    public void testStat() throws IOException, InterruptedException {
        this.testCommand("stats", new Field("version", String.class), new Field("read_only", Boolean.class), new Field("server_stats", ServerStats.class), new Field("node_count", Integer.class), new Field("connections", Iterable.class), new Field("secure_connections", Iterable.class), new Field("client_response", BufferStats.class));
    }

    @Test
    public void testStatReset() throws IOException, InterruptedException {
        this.testCommand("stat_reset", new Field[0]);
    }

    @Test
    public void testWatches() throws IOException, InterruptedException {
        this.testCommand("watches", new Field("session_id_to_watched_paths", Map.class));
    }

    @Test
    public void testWatchesByPath() throws IOException, InterruptedException {
        this.testCommand("watches_by_path", new Field("path_to_session_ids", Map.class));
    }

    @Test
    public void testWatchSummary() throws IOException, InterruptedException {
        this.testCommand("watch_summary", new Field("num_connections", Integer.class), new Field("num_paths", Integer.class), new Field("num_total_watches", Integer.class));
    }

    @Test
    public void testVotingViewCommand() throws IOException, InterruptedException {
        this.testCommand("voting_view", new Field("current_config", Map.class));
    }

    @Test
    public void testConsCommandSecureOnly() {
        Commands.ConsCommand cmd = new Commands.ConsCommand();
        ZooKeeperServer zkServer = (ZooKeeperServer)Mockito.mock(ZooKeeperServer.class);
        ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)Mockito.mock(ServerCnxnFactory.class);
        Mockito.when((Object)zkServer.getSecureServerCnxnFactory()).thenReturn((Object)cnxnFactory);
        CommandResponse response = cmd.run(zkServer, null);
        Assert.assertThat((Object)response.toMap().containsKey("connections"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.toMap().containsKey("secure_connections"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testStatCommandSecureOnly() {
        Commands.StatCommand cmd = new Commands.StatCommand();
        ZooKeeperServer zkServer = (ZooKeeperServer)Mockito.mock(ZooKeeperServer.class);
        ServerCnxnFactory cnxnFactory = (ServerCnxnFactory)Mockito.mock(ServerCnxnFactory.class);
        ServerStats serverStats = (ServerStats)Mockito.mock(ServerStats.class);
        ZKDatabase zkDatabase = (ZKDatabase)Mockito.mock(ZKDatabase.class);
        Mockito.when((Object)zkServer.getSecureServerCnxnFactory()).thenReturn((Object)cnxnFactory);
        Mockito.when((Object)zkServer.serverStats()).thenReturn((Object)serverStats);
        Mockito.when((Object)zkServer.getZKDatabase()).thenReturn((Object)zkDatabase);
        Mockito.when((Object)zkDatabase.getNodeCount()).thenReturn((Object)0);
        CommandResponse response = cmd.run(zkServer, null);
        Assert.assertThat((Object)response.toMap().containsKey("connections"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)response.toMap().containsKey("secure_connections"), (Matcher)Is.is((Object)true));
    }

    private static class Field {
        String key;
        Class<?> type;

        Field(String key, Class<?> type) {
            this.key = key;
            this.type = type;
        }
    }
}

