/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.List;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.LoggingControl;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.workers.Sender;

public class AcknowledgementManager {
    private static Log log = LogFactory.getLog(AcknowledgementManager.class);

    public static void piggybackAcksIfPresent(RMMsgContext rmMessageContext, StorageManager storageManager) throws SandeshaException {
        EndpointReference target;
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::piggybackAcksIfPresent");
        }
        if ((target = rmMessageContext.getTo()) == null || target.hasAnonymousAddress()) {
            EndpointReference acksToEPR;
            RMDBean inboundBean;
            String inboundSequence = (String)rmMessageContext.getProperty("Sandesha2InboundSequenceId");
            if (inboundSequence != null && (inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence)) != null && !inboundBean.isTerminated() && ((acksToEPR = inboundBean.getAcksToEndpointReference()) == null || acksToEPR.hasAnonymousAddress())) {
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug((Object)("Piggybacking ack for inbound sequence: " + inboundSequence));
                }
                RMMsgCreator.addAckMessage(rmMessageContext, inboundSequence, inboundBean, false, true);
            }
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent, anon");
            }
            return;
        }
        if (SandeshaUtil.hasReferenceParameters(target)) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent, target has refParams");
            }
            return;
        }
        String inboundSequence = (String)rmMessageContext.getProperty("Sandesha2InboundSequenceId");
        if (inboundSequence != null) {
            RMDBean sequence;
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)("Piggybacking ack for sequence: " + inboundSequence));
            }
            if ((sequence = storageManager.getRMDBeanMgr().retrieve(inboundSequence)) != null && !sequence.isTerminated()) {
                RMMsgCreator.addAckMessage(rmMessageContext, inboundSequence, sequence, false, true);
                ((Sender)storageManager.getSender()).removeScheduledAcknowledgement(inboundSequence);
            }
        } else {
            RMDBean findRMDBean = new RMDBean();
            findRMDBean.setAcksToEndpointReference(target);
            findRMDBean.setTerminated(false);
            List<RMDBean> rmdBeans = storageManager.getRMDBeanMgr().find(findRMDBean);
            for (RMDBean sequence : rmdBeans) {
                if (SandeshaUtil.hasReferenceParameters(sequence.getAcksToEndpointReference())) {
                    if (!LoggingControl.isAnyTracingEnabled() || !log.isDebugEnabled()) break;
                    log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent, target has refParams");
                    break;
                }
                String sequenceId = sequence.getSequenceID();
                if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                    log.debug((Object)("Piggybacking ack for sequence: " + sequenceId));
                }
                RMMsgCreator.addAckMessage(rmMessageContext, sequenceId, sequence, false, true);
                ((Sender)storageManager.getSender()).removeScheduledAcknowledgement(sequenceId);
            }
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent");
        }
    }

    public static RMMsgContext generateAckMessage(RMMsgContext referenceRMMessage, RMDBean rmdBean, String sequenceId, StorageManager storageManager, boolean serverSide) throws AxisFault {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Enter: AcknowledgementManager::generateAckMessage " + rmdBean));
        }
        MessageContext referenceMsg = referenceRMMessage.getMessageContext();
        EndpointReference acksTo = rmdBean.getAcksToEndpointReference();
        if (acksTo == null || acksTo.getAddress() == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), referenceMsg.getAxisService());
        MessageContext ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, ackOperation);
        ackMsgCtx.setProperty("Sandesha2AppProcessingDone", (Object)"true");
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setFlow(2);
        ackRMMsgCtx.setRMNamespaceValue(referenceRMMessage.getRMNamespaceValue());
        ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(referenceMsg.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        ackMsgCtx.setEnvelope(envelope);
        ackMsgCtx.setTo(acksTo);
        ackMsgCtx.setServerSide(serverSide);
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean, true, false);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::generateAckMessage");
        }
        return ackRMMsgCtx;
    }

    public static boolean verifySequenceCompletion(RangeString ackRanges, long lastMessageNo) {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::verifySequenceCompletion");
        }
        boolean result = false;
        Range complete = new Range(1L, lastMessageNo);
        if (ackRanges.isRangeCompleted(complete)) {
            result = true;
        }
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)("Exit: AcknowledgementManager::verifySequenceCompletion " + result));
        }
        return result;
    }

    public static void addAckBeanEntry(RMMsgContext ackRMMsgContext, String sequenceId, long timeToSend, StorageManager storageManager) throws AxisFault {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::addAckBeanEntry");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        String key = SandeshaUtil.getUUID();
        SenderBean ackBean = new SenderBean();
        ackBean.setMessageContextRefKey(key);
        ackBean.setMessageID(ackMsgContext.getMessageID());
        ackBean.setReSend(false);
        ackBean.setSequenceID(sequenceId);
        EndpointReference to = ackMsgContext.getTo();
        if (to != null) {
            ackBean.setToAddress(to.getAddress());
        }
        ackBean.setSend(true);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        ackBean.setMessageType(4);
        SenderBean findBean = new SenderBean();
        findBean.setMessageType(4);
        findBean.setSend(true);
        findBean.setReSend(false);
        findBean.setSequenceID(sequenceId);
        List<SenderBean> coll = retransmitterBeanMgr.find(findBean);
        for (SenderBean oldAckBean : coll) {
            if (oldAckBean.getTimeToSend() < timeToSend) {
                timeToSend = oldAckBean.getTimeToSend();
            }
            retransmitterBeanMgr.delete(oldAckBean.getMessageID());
            storageManager.removeMessageContext(oldAckBean.getMessageContextRefKey());
        }
        ackBean.setTimeToSend(timeToSend);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        ackMsgContext.setProperty("Sandesha2SetSendToTrue", (Object)"true");
        SandeshaUtil.executeAndStore(ackRMMsgContext, key, storageManager);
        retransmitterBeanMgr.insert(ackBean);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::addAckBeanEntry");
        }
    }

    public static void sendAckNow(RMMsgContext ackRMMsgContext) throws AxisFault {
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::sendAckNow");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        if (ackRMMsgContext.getMessageContext().getOperationContext() == null) {
            AxisOperation op = ackMsgContext.getAxisOperation();
            OperationContext opCtx = OperationContextFactory.createOperationContext((int)op.getAxisSpecificMEPConstant(), (AxisOperation)op, (ServiceContext)ackRMMsgContext.getMessageContext().getServiceContext());
            ackRMMsgContext.getMessageContext().setOperationContext(opCtx);
        }
        ackRMMsgContext.getMessageContext().setServerSide(true);
        AxisEngine.send((MessageContext)ackMsgContext);
        if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::sendAckNow");
        }
    }
}

