/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.opensaml.xml.security.EvaluableCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaFilteringIterator<T>
implements Iterator<T> {
    private Iterator<? extends T> candidateIter;
    private Set<EvaluableCriteria<T>> criteriaSet;
    private boolean meetAll;
    private boolean unevaledSatisfies;
    private T current;

    public CriteriaFilteringIterator(Iterator<? extends T> candidatesIterator, Set<EvaluableCriteria<T>> criteria, boolean meetAllCriteria, boolean unevaluableSatisfies) {
        this.candidateIter = candidatesIterator;
        this.criteriaSet = criteria;
        this.meetAll = meetAllCriteria;
        this.unevaledSatisfies = unevaluableSatisfies;
        this.current = null;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        this.current = this.getNextMatch();
        return this.current != null;
    }

    @Override
    public T next() {
        if (this.current != null) {
            T temp = this.current;
            this.current = null;
            return temp;
        }
        T temp = this.getNextMatch();
        if (temp != null) {
            return temp;
        }
        throw new NoSuchElementException("No more elements are available");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation is not supported by this iterator");
    }

    private T getNextMatch() {
        while (this.candidateIter.hasNext()) {
            T candidate = this.candidateIter.next();
            if (!this.match(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private boolean match(T candidate) {
        boolean sawOneSatisfied = false;
        if (this.criteriaSet.isEmpty()) {
            return true;
        }
        for (EvaluableCriteria<T> criteria : this.criteriaSet) {
            Boolean result = criteria.evaluate(candidate);
            if (result == Boolean.FALSE) {
                if (!this.meetAll) continue;
                return false;
            }
            if (result == Boolean.TRUE) {
                if (!this.meetAll) {
                    return true;
                }
                sawOneSatisfied = true;
                continue;
            }
            if (this.meetAll && !this.unevaledSatisfies) {
                return false;
            }
            if (!this.meetAll && this.unevaledSatisfies) {
                return true;
            }
            if (!this.unevaledSatisfies) continue;
            sawOneSatisfied = true;
        }
        return sawOneSatisfied;
    }
}

