/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.builder;

import java.util.ArrayList;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.impl.builder.BuilderListener;
import org.apache.axiom.core.impl.builder.DeferredAction;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.common.builder.CustomBuilderRegistration;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;
import org.apache.axiom.om.impl.intf.factory.AxiomElementType;
import org.apache.axiom.om.impl.intf.factory.AxiomNodeFactory;
import org.apache.axiom.soap.impl.intf.AxiomSOAPElement;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeaderBlock;
import org.apache.axiom.soap.impl.intf.soap11.AxiomSOAP11HeaderBlock;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12HeaderBlock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class CustomBuilderManager
implements BuilderListener {
    private static final Log log = LogFactory.getLog(CustomBuilderManager.class);
    private ArrayList<CustomBuilderRegistration> registrations;
    private AxiomElement lastCandidateElement;
    private int lastCandidateDepth = -1;

    CustomBuilderManager() {
    }

    void register(CustomBuilder.Selector selector, CustomBuilder customBuilder) {
        DeferredAction action;
        if (this.registrations == null) {
            this.registrations = new ArrayList();
        }
        this.registrations.add(new CustomBuilderRegistration(selector, customBuilder));
        if (this.lastCandidateElement != null && (action = this.getAction(this.lastCandidateElement, this.lastCandidateDepth, this.registrations.size() - 1)) != null) {
            try {
                action.run();
            }
            catch (CoreModelException ex) {
                throw AxiomExceptionTranslator.translate(ex);
            }
        }
    }

    @Override
    public DeferredAction nodeAdded(CoreNode node, int depth) {
        return this.getAction(node, depth, 0);
    }

    private DeferredAction getAction(CoreNode node, int depth, int firstCustomBuilder) {
        this.lastCandidateElement = null;
        this.lastCandidateDepth = -1;
        if (node instanceof AxiomElement && (node instanceof AxiomSOAPHeaderBlock || !(node instanceof AxiomSOAPElement))) {
            AxiomElement element = (AxiomElement)node;
            if (this.registrations != null) {
                for (int i = firstCustomBuilder; i < this.registrations.size(); ++i) {
                    CustomBuilderRegistration registration = this.registrations.get(i);
                    String namespaceURI = element.coreGetNamespaceURI();
                    String localName = element.coreGetLocalName();
                    if (!registration.getSelector().accepts(element.getParent(), depth, namespaceURI, localName)) continue;
                    CustomBuilder customBuilder = registration.getCustomBuilder();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Custom builder " + customBuilder + " accepted element {" + namespaceURI + "}" + localName + " at depth " + depth));
                    }
                    return () -> {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Invoking custom builder " + customBuilder));
                        }
                        OMDataSource dataSource = customBuilder.create((OMElement)element);
                        AxiomElementType<AxiomSourcedElement> type = element instanceof AxiomSOAP11HeaderBlock ? AxiomNodeFactory::createSOAP11HeaderBlock : (element instanceof AxiomSOAP12HeaderBlock ? AxiomNodeFactory::createSOAP12HeaderBlock : AxiomNodeFactory::createSourcedElement);
                        AxiomSourcedElement newElement = type.create((AxiomNodeFactory)element.coreGetNodeFactory().getFactory2());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Replacing element with new sourced element of type " + newElement.getClass().getName()));
                        }
                        newElement.init(localName, new OMNamespaceImpl(namespaceURI, null), dataSource);
                        try {
                            element.coreReplaceWith(newElement, AxiomSemantics.INSTANCE);
                        }
                        catch (CoreModelException ex) {
                            throw AxiomExceptionTranslator.translate(ex);
                        }
                    };
                }
            }
            this.lastCandidateElement = element;
            this.lastCandidateDepth = depth;
        }
        return null;
    }
}

