/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractServiceDispatcher
extends AbstractHandler {
    public static final String NAME = "AbstractServiceDispatcher";
    private static final Log log = LogFactory.getLog(AbstractServiceDispatcher.class);

    public AbstractServiceDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public abstract AxisService findService(MessageContext var1) throws AxisFault;

    public abstract void initDispatcher();

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        AxisService axisService = msgctx.getAxisService();
        if (axisService == null && (axisService = this.findService(msgctx)) != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(msgctx.getLogIDString() + " " + Messages.getMessage("servicefound", axisService.getName())));
            }
            msgctx.setAxisService(axisService);
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

