/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.activation.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.MessageFormatterEx;
import org.apache.axis2.format.TextFromElementDataSource;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;

public class PlainTextFormatter
implements MessageFormatterEx {
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement textElt = messageContext.getEnvelope().getBody().getFirstElement();
        if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(textElt.getQName())) {
            try {
                OutputStreamWriter out = new OutputStreamWriter(outputStream, format.getCharSetEncoding());
                textElt.writeTextTo((Writer)out, preserve);
                ((Writer)out).flush();
            }
            catch (IOException e) {
                throw new AxisFault("Error writing text message to stream", (Throwable)e);
            }
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = "text/plain";
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = contentType + ";action=\"" + soapAction + "\";";
        }
        return contentType;
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL((URL)targetURL, (MessageContext)msgCtxt, (boolean)false);
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }

    @Override
    public DataSource getDataSource(MessageContext messageContext, OMOutputFormat format, String soapAction) throws AxisFault {
        return new TextFromElementDataSource(messageContext.getEnvelope().getBody().getFirstElement(), format.getCharSetEncoding(), this.getContentType(messageContext, format, soapAction));
    }
}

