/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Metamodel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class JpaClassUtils {
    private JpaClassUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        EntityManager entityManager;
        Object object = em.getDelegate();
        if (object instanceof EntityManager) {
            void delegate;
            EntityManager entityManager2 = (EntityManager)object;
            EntityManager cfr_ignored_0 = (EntityManager)object;
            entityManager = delegate;
        } else {
            entityManager = em;
        }
        EntityManager entityManagerToUse = entityManager;
        return JpaClassUtils.isOfType(entityManagerToUse, type, entityManagerToUse.getClass().getClassLoader());
    }

    public static boolean isMetamodelOfType(Metamodel metamodel, String type) {
        return JpaClassUtils.isOfType(metamodel, type, metamodel.getClass().getClassLoader());
    }

    private static boolean isOfType(Object source, String typeName, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)source, (String)"Source instance must not be null");
        Assert.hasText((String)typeName, (String)"Target type name must not be null or empty");
        try {
            return ClassUtils.forName((String)typeName, (ClassLoader)classLoader).isInstance(source);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

