/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.facade.JmsObjectMessageFacade;

public class JmsObjectMessage
extends JmsMessage
implements ObjectMessage {
    private final JmsObjectMessageFacade facade;

    public JmsObjectMessage(JmsObjectMessageFacade facade) {
        super(facade);
        this.facade = facade;
    }

    @Override
    public JmsObjectMessage copy() throws JMSException {
        JmsObjectMessage other = new JmsObjectMessage(this.facade.copy());
        other.copy(this);
        return other;
    }

    public void setObject(Serializable newObject) throws JMSException {
        this.checkReadOnlyBody();
        try {
            this.facade.setObject(newObject);
        }
        catch (Exception e) {
            MessageFormatException jmsEx = new MessageFormatException("Failed to serialize object:" + e.getMessage());
            jmsEx.setLinkedException(e);
            jmsEx.initCause((Throwable)e);
            throw jmsEx;
        }
    }

    public Serializable getObject() throws JMSException {
        try {
            return this.facade.getObject();
        }
        catch (Exception e) {
            MessageFormatException jmsEx = new MessageFormatException("Failed to read object: " + e.getMessage());
            jmsEx.setLinkedException(e);
            jmsEx.initCause((Throwable)e);
            throw jmsEx;
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class target) throws JMSException {
        if (!this.facade.hasBody()) {
            return true;
        }
        return Serializable.class == target || Object.class == target || target.isInstance(this.getObject());
    }

    @Override
    protected <T> T doGetBody(Class<T> asType) throws JMSException {
        try {
            return (T)this.getObject();
        }
        catch (JMSException e) {
            MessageFormatException jmsEx = new MessageFormatException("Failed to read object: " + e.getMessage());
            jmsEx.setLinkedException((Exception)((Object)e));
            jmsEx.initCause((Throwable)e);
            throw jmsEx;
        }
    }

    @Override
    public String toString() {
        return "JmsObjectMessageFacade { " + this.facade.toString() + " }";
    }
}

