/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class DateUtil {
    private static DatatypeFactory datatypeFactory;

    private DateUtil() {
    }

    public static Date fromISO8601(String pDateString) {
        if (datatypeFactory != null) {
            return datatypeFactory.newXMLGregorianCalendar(pDateString.trim()).toGregorianCalendar().getTime();
        }
        try {
            String date = pDateString.replaceFirst("([+-])(0\\d):(\\d{2})$", "$1$2$3");
            date = date.replaceFirst("Z$", "+0000");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            return dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date '" + pDateString + "': " + String.valueOf(e), e);
        }
    }

    public static String toISO8601(Date pDate) {
        return DateUtil.toISO8601(pDate, TimeZone.getDefault());
    }

    public static String toISO8601(Date pDate, TimeZone pTimeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        dateFormat.setTimeZone(pTimeZone);
        String ret = dateFormat.format(pDate);
        ret = ret.replaceAll("\\+0000$", "Z");
        return ret.replaceAll("(\\d\\d)$", ":$1");
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            datatypeFactory = null;
        }
    }
}

