/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;

public final class AMQPFederationEventSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage encodeQueueAddedEvent(String address, String queue) {
        LinkedHashMap<Symbol, String> annotations = new LinkedHashMap<Symbol, String>();
        MessageAnnotations messageAnnotations = new MessageAnnotations(annotations);
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        AmqpValue sectionBody = new AmqpValue(eventMap);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        annotations.put(AMQPFederationConstants.EVENT_TYPE, "REQUESTED_QUEUE_ADDED_EVENT");
        eventMap.put("REQUESTED_ADDRESS_NAME", address);
        eventMap.put("REQUESTED_QUEUE_NAME", queue);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject((Object)messageAnnotations);
            encoder.writeObject((Object)sectionBody);
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage aMQPStandardMessage = new AMQPStandardMessage(0L, data, null);
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage encodeAddressAddedEvent(String address) {
        LinkedHashMap<Symbol, String> annotations = new LinkedHashMap<Symbol, String>();
        MessageAnnotations messageAnnotations = new MessageAnnotations(annotations);
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        AmqpValue sectionBody = new AmqpValue(eventMap);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        annotations.put(AMQPFederationConstants.EVENT_TYPE, "REQUESTED_ADDRESS_ADDED_EVENT");
        eventMap.put("REQUESTED_ADDRESS_NAME", address);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject((Object)messageAnnotations);
            encoder.writeObject((Object)sectionBody);
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage aMQPStandardMessage = new AMQPStandardMessage(0L, data, null);
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    public static Map<String, Object> decodeQueueAddedEvent(AMQPMessage message) throws ActiveMQException {
        Section body = message.getBody();
        if (!(body instanceof AmqpValue)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body was not an AmqpValue type");
        }
        AmqpValue bodyValue = (AmqpValue)body;
        if (!(bodyValue.getValue() instanceof Map)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body AmqpValue did not carry an encoded Map");
        }
        try {
            Map eventMap = (Map)bodyValue.getValue();
            if (!eventMap.containsKey("REQUESTED_ADDRESS_NAME")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationEventMessage("Message body did not carry the required address name");
            }
            if (!eventMap.containsKey("REQUESTED_QUEUE_NAME")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationEventMessage("Message body did not carry the required queue name");
            }
            return eventMap;
        }
        catch (ActiveMQException amqEx) {
            throw amqEx;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Invalid encoded queue added event entry: " + e.getMessage());
        }
    }

    public static Map<String, Object> decodeAddressAddedEvent(AMQPMessage message) throws ActiveMQException {
        Section body = message.getBody();
        if (!(body instanceof AmqpValue)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body was not an AmqpValue type");
        }
        AmqpValue bodyValue = (AmqpValue)body;
        if (!(bodyValue.getValue() instanceof Map)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body AmqpValue did not carry an encoded Map");
        }
        try {
            Map eventMap = (Map)bodyValue.getValue();
            if (!eventMap.containsKey("REQUESTED_ADDRESS_NAME")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationEventMessage("Message body did not carry the required address name");
            }
            return eventMap;
        }
        catch (ActiveMQException amqEx) {
            throw amqEx;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Invalid encoded address added event entry: " + e.getMessage());
        }
    }
}

