/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagerControl;

public final class AMQPBridgeManagerControlType
extends AbstractControl
implements AMQPBridgeManagerControl {
    private final AMQPBridgeManager bridge;

    public AMQPBridgeManagerControlType(ActiveMQServer server, AMQPBridgeManager bridge) throws NotCompliantMBeanException {
        super(AMQPBridgeManagerControl.class, server.getStorageManager());
        this.bridge = bridge;
    }

    @Override
    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.bridge);
        }
        this.clearIO();
        try {
            String string = this.bridge.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesReceived() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesReceived((Object)this.bridge);
        }
        this.clearIO();
        try {
            long l = this.bridge.getMetrics().getMessagesReceived();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getMessagesSent() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getMessagesSent((Object)this.bridge);
        }
        this.clearIO();
        try {
            long l = this.bridge.getMetrics().getMessagesSent();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AMQPBridgeManagerControl.class);
    }

    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AMQPBridgeManagerControl.class);
    }
}

