/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.channel.ChannelHandler;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionChannelHandler;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManagers;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerAggregation;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.ReferenceIDSupplier;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPTunneledCoreMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.protocol.amqp.sasl.scram.SCRAMClientSASL;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.scram.SCRAM;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBrokerConnection
implements ClientConnectionLifeCycleListener,
ActiveMQServerQueuePlugin,
BrokerConnection {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final boolean DEFAULT_CORE_MESSAGE_TUNNELING_ENABLED = true;
    private static final NettyConnectorFactory CONNECTOR_FACTORY = new NettyConnectorFactory().setServerConnector(true);
    private static final String SASL_MECHANISMS_KEY = "saslMechanisms";
    private final ProtonProtocolManagerFactory protonProtocolManagerFactory;
    private final ReferenceIDSupplier referenceIdSupplier;
    private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;
    private final ActiveMQServer server;
    private final List<TransportConfiguration> configurations;
    private final AMQPBrokerConnectionManager connectionManager;
    private NettyConnection connection;
    private Session session;
    private AMQPSessionContext sessionContext;
    private ActiveMQProtonRemotingConnection protonRemotingConnection;
    private volatile boolean started = false;
    private AMQPMirrorControllerSource mirrorControllerSource;
    private AMQPFederationSource brokerFederation;
    private AMQPBridgeManagers bridgeManagers;
    private int retryCounter = 0;
    private int lastRetryCounter;
    private int connectionTimeout;
    private boolean connecting = false;
    private volatile ScheduledFuture<?> reconnectFuture;
    private final Set<Queue> senders = new HashSet<Queue>();
    private final Set<Queue> receivers = new HashSet<Queue>();
    private final Map<String, Predicate<Link>> linkClosedInterceptors = new ConcurrentHashMap<String, Predicate<Link>>();
    final Executor connectExecutor;
    final ScheduledExecutorService scheduledExecutorService;
    String host;
    int port;
    private static final String EXTERNAL = "EXTERNAL";
    private static final String PLAIN = "PLAIN";
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final String XOAUTH2 = "XOAUTH2";
    private static final byte[] EMPTY = new byte[0];

    public AMQPBrokerConnection(AMQPBrokerConnectionManager connectionManager, AMQPBrokerConnectConfiguration brokerConnectConfiguration, ProtonProtocolManagerFactory protonProtocolManagerFactory, ActiveMQServer server) throws Exception {
        this.connectionManager = connectionManager;
        this.brokerConnectConfiguration = brokerConnectConfiguration;
        this.server = server;
        this.configurations = brokerConnectConfiguration.getTransportConfigurations();
        this.connectExecutor = server.getExecutorFactory().getExecutor();
        this.scheduledExecutorService = server.getScheduledPool();
        this.protonProtocolManagerFactory = protonProtocolManagerFactory;
        this.referenceIdSupplier = new ReferenceIDSupplier(server);
    }

    public String getName() {
        return this.brokerConnectConfiguration.getName();
    }

    public String getProtocol() {
        return "AMQP";
    }

    public AMQPBrokerConnectConfiguration getConfiguration() {
        return this.brokerConnectConfiguration;
    }

    public boolean isConnected() {
        NettyConnection connection = this.connection;
        if (connection != null) {
            return connection.isOpen();
        }
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public synchronized void initialize() throws Exception {
        try {
            this.server.registerBrokerConnection((BrokerConnection)this);
            this.server.getManagementService().registerBrokerConnection((BrokerConnection)this);
            if (this.brokerConnectConfiguration != null && this.brokerConnectConfiguration.getConnectionElements() != null) {
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    AMQPBrokerConnectionAddressType elementType = connectionElement.getType();
                    if (elementType == AMQPBrokerConnectionAddressType.FEDERATION) {
                        this.installFederation((AMQPFederatedBrokerConnectionElement)connectionElement, this.server);
                        continue;
                    }
                    if (elementType != AMQPBrokerConnectionAddressType.BRIDGE) continue;
                    this.installBridgeManager((AMQPBridgeBrokerConnectionElement)connectionElement, this.server);
                }
            }
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            this.started = true;
            this.server.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)this);
            try {
                if (this.brokerConnectConfiguration != null && this.brokerConnectConfiguration.getConnectionElements() != null) {
                    for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                        AMQPBrokerConnectionAddressType elementType = connectionElement.getType();
                        if (elementType != AMQPBrokerConnectionAddressType.MIRROR) continue;
                        this.installMirrorController((AMQPMirrorBrokerConnectionElement)connectionElement, this.server);
                    }
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
            if (this.brokerFederation != null) {
                try {
                    this.brokerFederation.start();
                }
                catch (ActiveMQException e) {
                    logger.warn("Error caught while starting federation instance.", (Throwable)e);
                }
            }
            if (this.bridgeManagers != null) {
                try {
                    this.bridgeManagers.start();
                }
                catch (ActiveMQException e) {
                    logger.warn("Error caught while starting bridge managers instance.", (Throwable)e);
                }
            }
            this.connectExecutor.execute(() -> this.doConnect());
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            this.server.getConfiguration().unRegisterBrokerPlugin((ActiveMQServerBasePlugin)this);
            if (this.protonRemotingConnection != null) {
                this.protonRemotingConnection.fail(new ActiveMQException("Stopping Broker Connection"));
                this.protonRemotingConnection = null;
                this.connection = null;
            }
            ScheduledFuture<?> scheduledFuture = this.reconnectFuture;
            this.reconnectFuture = null;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            if (this.brokerFederation != null) {
                try {
                    this.brokerFederation.stop();
                }
                catch (Exception e) {
                    logger.debug("Error caught while stopping federation instance.", (Throwable)e);
                }
            }
            if (this.bridgeManagers != null) {
                try {
                    this.bridgeManagers.stop();
                }
                catch (Exception e) {
                    logger.warn("Error caught while stopping bridge managers instance.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void shutdown() throws Exception {
        try {
            this.stop();
            return;
        }
        finally {
            if (this.brokerFederation != null) {
                try {
                    this.brokerFederation.shutdown();
                }
                catch (ActiveMQException e) {
                    logger.debug("Error caught while shutting down federation instance.", (Throwable)e);
                }
                finally {
                    this.brokerFederation = null;
                }
            }
            if (this.bridgeManagers != null) {
                try {
                    this.bridgeManagers.shutdown();
                }
                catch (Exception e) {
                    logger.debug("Error caught while shutting down bridge managers instance.", (Throwable)e);
                }
                finally {
                    this.bridgeManagers = null;
                }
            }
            this.server.unregisterBrokerConnection((BrokerConnection)this);
            this.server.getManagementService().unregisterBrokerConnection(this.getName());
        }
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public NettyConnection getConnection() {
        return this.connection;
    }

    public void afterCreateQueue(Queue queue) {
        this.connectExecutor.execute(() -> {
            for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                this.validateMatching(queue, connectionElement);
            }
        });
    }

    public void validateMatching(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() == AMQPBrokerConnectionAddressType.SENDER || connectionElement.getType() == AMQPBrokerConnectionAddressType.RECEIVER || connectionElement.getType() == AMQPBrokerConnectionAddressType.PEER) {
            if (connectionElement.getQueueName() != null) {
                if (queue.getName().equals((Object)connectionElement.getQueueName())) {
                    this.createLink(queue, connectionElement);
                }
            } else if (connectionElement.match(queue.getAddress(), this.server.getConfiguration().getWildcardConfiguration())) {
                this.createLink(queue, connectionElement);
            }
        }
    }

    public void createLink(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() == AMQPBrokerConnectionAddressType.PEER) {
            Symbol[] dispatchCapability = new Symbol[]{AMQPMirrorControllerSource.QPID_DISPATCH_WAYPOINT_CAPABILITY};
            this.connectSender(queue, queue.getAddress().toString(), null, null, null, null, dispatchCapability, null);
            this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, dispatchCapability);
        } else if (connectionElement.getType() == AMQPBrokerConnectionAddressType.SENDER) {
            this.connectSender(queue, queue.getAddress().toString(), null, null, null, null, null, null);
        } else if (connectionElement.getType() == AMQPBrokerConnectionAddressType.RECEIVER) {
            this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, new Symbol[0]);
        }
    }

    SimpleString getMirrorSNF(AMQPMirrorBrokerConnectionElement mirrorElement) {
        SimpleString snf = mirrorElement.getMirrorSNF();
        if (snf == null) {
            snf = SimpleString.of((String)ProtonProtocolManager.getMirrorAddress(this.brokerConnectConfiguration.getName()));
            mirrorElement.setMirrorSNF(snf);
        }
        return snf;
    }

    public AMQPBrokerConnection addLinkClosedInterceptor(String id, Predicate<Link> interceptor) {
        this.linkClosedInterceptors.put(id, interceptor);
        return this;
    }

    public AMQPBrokerConnection removeLinkClosedInterceptor(String id) {
        this.linkClosedInterceptors.remove(id);
        return this;
    }

    private void linkClosed(Link link) {
        for (Map.Entry<String, Predicate<Link>> interceptor : this.linkClosedInterceptors.entrySet()) {
            if (!interceptor.getValue().test(link)) continue;
            logger.trace("Remote link[{}] close intercepted and handled by interceptor: {}", (Object)link.getName(), (Object)interceptor.getKey());
            return;
        }
        if (link.getLocalState() == EndpointState.ACTIVE) {
            this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionRemoteLinkClosed()), this.lastRetryCounter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        try {
            Symbol[] symbolArray;
            this.connecting = true;
            TransportConfiguration configuration = this.configurations.get(this.retryCounter % this.configurations.size());
            this.host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)configuration.getParams());
            this.port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)configuration.getParams());
            ProtonProtocolManager protonProtocolManager = (ProtonProtocolManager)this.protonProtocolManagerFactory.createProtocolManager(this.server, configuration.getExtraParams(), null, null);
            NettyConnector connector = (NettyConnector)CONNECTOR_FACTORY.createConnector(configuration.getParams(), null, (ClientConnectionLifeCycleListener)this, (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getThreadPool(), this.server.getScheduledPool(), (ClientProtocolManager)new AMQPBrokerConnectionManager.ClientProtocolManagerWithAMQP(protonProtocolManager));
            connector.start();
            logger.debug("Connecting {}", (Object)configuration);
            this.connectionTimeout = connector.getConnectTimeoutMillis();
            try {
                this.connection = (NettyConnection)connector.createConnection();
                if (this.connection == null) {
                    this.retryConnection();
                    return;
                }
            }
            finally {
                if (this.connection == null) {
                    try {
                        connector.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.lastRetryCounter = this.retryCounter;
            this.retryCounter = 0;
            this.reconnectFuture = null;
            this.senders.clear();
            this.receivers.clear();
            String[] enabledSaslMechanisms = configuration.getExtraParams().containsKey(SASL_MECHANISMS_KEY) ? protonProtocolManager.getSaslMechanisms() : null;
            SaslFactory saslFactory = new SaslFactory(this.connection, this.brokerConnectConfiguration, enabledSaslMechanisms);
            HashMap<String, String> brokerConnectionInfo = new HashMap<String, String>();
            brokerConnectionInfo.put("connectionName", this.getName());
            brokerConnectionInfo.put("nodeId", this.server.getNodeID().toString());
            HashMap<Symbol, Object> brokerConnectionProperties = new HashMap<Symbol, Object>();
            brokerConnectionProperties.put(AMQPBrokerConnectionConstants.BROKER_CONNECTION_INFO, brokerConnectionInfo);
            if (this.bridgeManagers == null) {
                symbolArray = null;
            } else {
                Symbol[] symbolArray2 = new Symbol[1];
                symbolArray = symbolArray2;
                symbolArray2[0] = AmqpSupport.SHARED_SUBS;
            }
            Symbol[] brokerDesiredCapabilities = symbolArray;
            NettyConnectorCloseHandler connectorCloseHandler = new NettyConnectorCloseHandler(connector, this.connectExecutor);
            ConnectionEntry entry = protonProtocolManager.createOutgoingConnectionEntry((Connection)this.connection, saslFactory, brokerConnectionProperties, null, brokerDesiredCapabilities);
            this.server.getRemotingService().addConnectionEntry((Connection)this.connection, entry);
            this.protonRemotingConnection = (ActiveMQProtonRemotingConnection)entry.connection;
            this.protonRemotingConnection.getAmqpConnection().addLinkRemoteCloseListener(this.getName(), this::linkClosed);
            this.protonRemotingConnection.addCloseListener(connectorCloseHandler);
            this.protonRemotingConnection.addFailureListener(connectorCloseHandler);
            this.connection.getChannel().pipeline().addLast(new ChannelHandler[]{new AMQPBrokerConnectionChannelHandler(connector.getChannelGroup(), this.protonRemotingConnection.getAmqpConnection().getHandler(), this, (Executor)this.server.getExecutorFactory().getExecutor())});
            this.session = this.protonRemotingConnection.getAmqpConnection().getHandler().getConnection().session();
            this.sessionContext = this.protonRemotingConnection.getAmqpConnection().getSessionExtension(this.session);
            this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
                this.protonRemotingConnection.getAmqpConnection().addRemoteOpenedListener(c -> {
                    try {
                        if (this.bridgeManagers != null) {
                            this.bridgeManagers.connectionRestored(this.sessionContext);
                        }
                    }
                    catch (Throwable e) {
                        this.error(e);
                    }
                    finally {
                        this.protonRemotingConnection.getAmqpConnection().flush();
                    }
                });
                this.protonRemotingConnection.getAmqpConnection().open();
                this.session.open();
                this.protonRemotingConnection.getAmqpConnection().flush();
            });
            if (this.brokerConnectConfiguration.getConnectionElements() != null) {
                Stream bindingStream = this.server.getPostOffice().getAllBindings();
                bindingStream.forEach(binding -> {
                    if (binding instanceof QueueBinding) {
                        QueueBinding queueBinding = (QueueBinding)binding;
                        Queue queue = queueBinding.getQueue();
                        for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                            this.validateMatching(queue, connectionElement);
                        }
                    }
                });
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    if (connectionElement.getType() == AMQPBrokerConnectionAddressType.MIRROR) {
                        AMQPMirrorBrokerConnectionElement replica = (AMQPMirrorBrokerConnectionElement)connectionElement;
                        Queue queue = this.server.locateQueue(this.getMirrorSNF(replica));
                        boolean coreTunnelingEnabled = AMQPBrokerConnection.isCoreMessageTunnelingEnabled(replica);
                        Symbol[] desiredCapabilities = coreTunnelingEnabled ? new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT} : new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY};
                        Symbol[] requiredOfferedCapabilities = new Symbol[]{AMQPMirrorControllerSource.MIRROR_CAPABILITY};
                        this.connectSender(queue, queue.getName().toString(), this.mirrorControllerSource::setLink, r -> AMQPMirrorControllerSource.validateProtocolData(protonProtocolManager.getReferenceIDSupplier(), r, this.getMirrorSNF(replica)), this.server.getNodeID().toString(), desiredCapabilities, null, requiredOfferedCapabilities);
                        continue;
                    }
                    if (connectionElement.getType() != AMQPBrokerConnectionAddressType.FEDERATION) continue;
                    this.brokerFederation.connectionRestored(this.protonRemotingConnection.getAmqpConnection(), this.sessionContext);
                }
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
            this.connectionManager.connected(this.connection, this);
            ActiveMQAMQPProtocolLogger.LOGGER.successReconnect(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.lastRetryCounter);
            this.connecting = false;
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    public void retryConnection() {
        this.lastRetryCounter = this.retryCounter;
        if (this.connectionManager.isStarted() && this.started) {
            if (this.brokerConnectConfiguration.getReconnectAttempts() < 0 || this.retryCounter < this.brokerConnectConfiguration.getReconnectAttempts()) {
                ++this.retryCounter;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnection(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.retryCounter, this.brokerConnectConfiguration.getReconnectAttempts());
                if (logger.isDebugEnabled()) {
                    logger.debug("Reconnecting in {}, this is the {} of {}", new Object[]{this.brokerConnectConfiguration.getRetryInterval(), this.retryCounter, this.brokerConnectConfiguration.getReconnectAttempts()});
                }
                this.reconnectFuture = this.scheduledExecutorService.schedule(() -> this.connectExecutor.execute(() -> this.doConnect()), (long)this.brokerConnectConfiguration.getRetryInterval(), TimeUnit.MILLISECONDS);
            } else {
                this.retryCounter = 0;
                this.started = false;
                this.connecting = false;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnectionFailed(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.lastRetryCounter);
                if (logger.isDebugEnabled()) {
                    logger.debug("no more reconnections as the retry counter reached {} out of {}", (Object)this.retryCounter, (Object)this.brokerConnectConfiguration.getReconnectAttempts());
                }
            }
        }
    }

    private static void uninstallMirrorController(AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) {
    }

    private Queue installMirrorController(AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) throws Exception {
        AMQPMirrorControllerSource newPartition;
        AddressInfo addressInfo;
        MirrorController currentMirrorController = server.getMirrorController();
        if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerSource) {
            AMQPMirrorControllerSource source = (AMQPMirrorControllerSource)currentMirrorController;
            Queue queue = AMQPBrokerConnection.checkCurrentMirror(this, source);
            if (queue != null) {
                queue.deliverAsync();
                return queue;
            }
        } else if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerAggregation) {
            AMQPMirrorControllerAggregation aggregation = (AMQPMirrorControllerAggregation)currentMirrorController;
            for (AMQPMirrorControllerSource source : aggregation.getPartitions()) {
                Queue queue = AMQPBrokerConnection.checkCurrentMirror(this, source);
                if (queue == null) continue;
                return queue;
            }
        }
        if ((addressInfo = server.getAddressInfo(this.getMirrorSNF(replicaConfig))) == null) {
            addressInfo = new AddressInfo(this.getMirrorSNF(replicaConfig)).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false).setTemporary(!replicaConfig.isDurable()).setInternal(true);
            server.addAddressInfo(addressInfo);
        }
        if (addressInfo.getRoutingType() != RoutingType.ANYCAST) {
            throw new IllegalArgumentException(String.valueOf(addressInfo.getName()) + " has " + String.valueOf(addressInfo.getRoutingType()) + " instead of ANYCAST");
        }
        Queue mirrorControlQueue = server.locateQueue(this.getMirrorSNF(replicaConfig));
        if (mirrorControlQueue == null) {
            mirrorControlQueue = server.createQueue(QueueConfiguration.of((SimpleString)this.getMirrorSNF(replicaConfig)).setAddress(this.getMirrorSNF(replicaConfig)).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(replicaConfig.isDurable())).setInternal(Boolean.valueOf(true)), true);
        }
        try {
            server.registerQueueOnManagement(mirrorControlQueue);
        }
        catch (Throwable ignored) {
            logger.debug(ignored.getMessage(), ignored);
        }
        logger.debug("Mirror queue {}", (Object)mirrorControlQueue.getName());
        mirrorControlQueue.setMirrorController(true);
        QueueBinding snfReplicaQueueBinding = (QueueBinding)server.getPostOffice().getBinding(this.getMirrorSNF(replicaConfig));
        if (snfReplicaQueueBinding == null) {
            logger.warn("Queue does not exist even after creation! {}", (Object)replicaConfig);
            throw new IllegalAccessException("Cannot start replica");
        }
        Queue snfQueue = snfReplicaQueueBinding.getQueue();
        if (!snfQueue.getAddress().equals((Object)this.getMirrorSNF(replicaConfig))) {
            logger.warn("Queue {} belong to a different address ({}), while we expected it to be {}", new Object[]{snfQueue, snfQueue.getAddress(), addressInfo.getName()});
            throw new IllegalAccessException("Cannot start replica");
        }
        this.mirrorControllerSource = newPartition = new AMQPMirrorControllerSource(this.referenceIdSupplier, snfQueue, server, replicaConfig, this);
        server.scanAddresses((MirrorController)newPartition);
        if (currentMirrorController == null) {
            server.installMirrorController((MirrorController)newPartition);
        } else {
            if (currentMirrorController instanceof AMQPMirrorControllerSource) {
                AMQPMirrorControllerSource source = (AMQPMirrorControllerSource)currentMirrorController;
                AMQPMirrorControllerAggregation remoteAggregation = new AMQPMirrorControllerAggregation();
                remoteAggregation.addPartition(source);
                currentMirrorController = remoteAggregation;
                server.installMirrorController((MirrorController)remoteAggregation);
            }
            ((AMQPMirrorControllerAggregation)currentMirrorController).addPartition(newPartition);
        }
        return snfQueue;
    }

    private static Queue checkCurrentMirror(AMQPBrokerConnection brokerConnection, AMQPMirrorControllerSource currentMirrorController) {
        AMQPMirrorControllerSource source = currentMirrorController;
        if (source.getBrokerConnection() == brokerConnection) {
            return source.getSnfQueue();
        }
        return null;
    }

    private void installBridgeManager(AMQPBridgeBrokerConnectionElement connectionElement, ActiveMQServer server) throws Exception {
        if (this.bridgeManagers == null) {
            this.bridgeManagers = new AMQPBridgeManagers(this);
        }
        this.bridgeManagers.addBridgeManager(connectionElement);
    }

    private void installFederation(AMQPFederatedBrokerConnectionElement connectionElement, ActiveMQServer server) throws Exception {
        Set remoteQueuePolicies;
        Set remoteAddressPolicies;
        Set localQueuePolicies;
        AMQPFederationSource federation = new AMQPFederationSource(connectionElement.getName(), connectionElement.getProperties(), this);
        federation.initialize();
        Set localAddressPolicies = connectionElement.getLocalAddressPolicies();
        if (!localAddressPolicies.isEmpty()) {
            for (AMQPFederationAddressPolicyElement policy : localAddressPolicies) {
                federation.addAddressMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(localQueuePolicies = connectionElement.getLocalQueuePolicies()).isEmpty()) {
            for (AMQPFederationQueuePolicyElement policy : localQueuePolicies) {
                federation.addQueueMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(remoteAddressPolicies = connectionElement.getRemoteAddressPolicies()).isEmpty()) {
            for (AMQPFederationAddressPolicyElement policy : remoteAddressPolicies) {
                federation.addRemoteAddressMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        if (!(remoteQueuePolicies = connectionElement.getRemoteQueuePolicies()).isEmpty()) {
            for (AMQPFederationQueuePolicyElement policy : remoteQueuePolicies) {
                federation.addRemoteQueueMatchPolicy(AMQPFederationPolicySupport.create(policy, federation.getWildcardConfiguration()));
            }
        }
        this.brokerFederation = federation;
    }

    private void connectReceiver(ActiveMQProtonRemotingConnection protonRemotingConnection, Session session, AMQPSessionContext sessionContext, final Queue queue, Symbol ... capabilities) {
        logger.debug("Connecting inbound for {}", (Object)queue);
        if (session == null) {
            logger.debug("session is null");
            return;
        }
        protonRemotingConnection.getAmqpConnection().runLater(() -> {
            if (!this.receivers.add(queue)) {
                logger.debug("Receiver for queue {} already exists, just giving up", (Object)queue);
                return;
            }
            try {
                String linkName = queue.getAddress().toString() + ":" + UUIDGenerator.getInstance().generateStringUUID();
                Receiver receiver = session.receiver(linkName);
                String queueAddress = queue.getAddress().toString();
                final Target target = new Target();
                target.setAddress(queueAddress);
                Source source = new Source();
                source.setAddress(queueAddress);
                if (capabilities != null) {
                    source.setCapabilities(capabilities);
                }
                receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                receiver.open();
                AtomicBoolean openTimedOut = new AtomicBoolean(false);
                ScheduledFuture<?> openTimeoutTask = this.getConnectionTimeout() > 0 ? this.server.getScheduledPool().schedule(() -> {
                    openTimedOut.set(true);
                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()), this.lastRetryCounter);
                }, (long)this.getConnectionTimeout(), TimeUnit.MILLISECONDS) : null;
                receiver.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    try {
                        if (openTimeoutTask != null) {
                            openTimeoutTask.cancel(false);
                        }
                        if (openTimedOut.get()) {
                            return;
                        }
                        if (receiver.getRemoteSource() == null) {
                            logger.debug("AMQP Broker Connection Receiver {} rejected by remote", (Object)linkName);
                            this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.receiverLinkRefused(queueAddress)), this.lastRetryCounter);
                            return;
                        }
                        logger.trace("AMQP Broker Connection Receiver {} completed open", (Object)linkName);
                        sessionContext.addReceiver(receiver, (r, s) -> new ProtonServerReceiverContext(sessionContext.getSessionSPI(), sessionContext.getAMQPConnectionContext(), sessionContext, receiver){

                            @Override
                            public void initialize() throws Exception {
                                this.initialized = true;
                                this.address = SimpleString.of((String)target.getAddress());
                                this.defRoutingType = this.getRoutingType(target.getCapabilities(), this.address);
                                try {
                                    if (!this.sessionSPI.queueQuery(queue.getName(), queue.getRoutingType(), false).isExists()) {
                                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                                    }
                                }
                                catch (ActiveMQAMQPException e) {
                                    AMQPBrokerConnection.this.receivers.remove(queue);
                                    throw e;
                                }
                                catch (Exception e) {
                                    logger.debug(e.getMessage(), (Throwable)e);
                                    AMQPBrokerConnection.this.receivers.remove(queue);
                                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                                }
                                this.topUpCreditIfNeeded();
                            }
                        });
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                });
            }
            catch (Exception e) {
                this.error(e);
            }
            protonRemotingConnection.getAmqpConnection().flush();
        });
    }

    private void connectSender(Queue queue, String targetName, java.util.function.Consumer<Sender> senderConsumer, java.util.function.Consumer<? super MessageReference> beforeDeliver, String brokerID, Symbol[] desiredCapabilities, Symbol[] targetCapabilities, Symbol[] requiredOfferedCapabilities) {
        logger.debug("Connecting outbound for {}", (Object)queue);
        if (this.session == null) {
            logger.debug("Session is null");
            return;
        }
        this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
            try {
                if (this.senders.contains(queue)) {
                    logger.debug("Sender for queue {} already exists, just giving up", (Object)queue);
                    return;
                }
                this.senders.add(queue);
                Sender sender = this.session.sender(targetName + ":" + UUIDGenerator.getInstance().generateStringUUID());
                sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                Target target = new Target();
                target.setAddress(targetName);
                if (targetCapabilities != null) {
                    target.setCapabilities(targetCapabilities);
                }
                sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                Source source = new Source();
                source.setAddress(queue.getAddress().toString());
                sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                if (brokerID != null) {
                    HashMap<Symbol, String> mapProperties = new HashMap<Symbol, String>(1, 1.0f);
                    mapProperties.put(AMQPMirrorControllerSource.BROKER_ID, brokerID);
                    sender.setProperties(mapProperties);
                }
                if (desiredCapabilities != null) {
                    sender.setDesiredCapabilities(desiredCapabilities);
                }
                AMQPOutgoingController outgoingInitializer = new AMQPOutgoingController(queue, sender, this.sessionContext.getSessionSPI());
                sender.open();
                AtomicBoolean cancelled = new AtomicBoolean(false);
                ScheduledFuture<?> futureTimeout = this.getConnectionTimeout() > 0 ? this.server.getScheduledPool().schedule(() -> {
                    cancelled.set(true);
                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()), this.lastRetryCounter);
                }, (long)this.getConnectionTimeout(), TimeUnit.MILLISECONDS) : null;
                sender.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                    ProtonServerSenderContext senderContext = new ProtonServerSenderContext(this.protonRemotingConnection.getAmqpConnection(), sender, this.sessionContext, this.sessionContext.getSessionSPI(), outgoingInitializer).setBeforeDelivery(beforeDeliver);
                    try {
                        if (!cancelled.get()) {
                            if (futureTimeout != null) {
                                futureTimeout.cancel(false);
                            }
                            if (sender.getRemoteTarget() == null) {
                                this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.senderLinkRefused(sender.getTarget().getAddress())), this.lastRetryCounter);
                                return;
                            }
                            if (requiredOfferedCapabilities != null && !AmqpSupport.verifyOfferedCapabilities((Link)sender, requiredOfferedCapabilities)) {
                                this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(Arrays.toString(requiredOfferedCapabilities))), this.lastRetryCounter);
                                return;
                            }
                            if (brokerID != null) {
                                if (sender.getRemoteProperties() == null || !sender.getRemoteProperties().containsKey(AMQPMirrorControllerSource.BROKER_ID)) {
                                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingBrokerID()), this.lastRetryCounter);
                                    return;
                                }
                                Object remoteBrokerID = sender.getRemoteProperties().get(AMQPMirrorControllerSource.BROKER_ID);
                                if (remoteBrokerID.equals(brokerID)) {
                                    this.error((Throwable)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionMirrorItself()), this.lastRetryCounter);
                                    return;
                                }
                            }
                            this.sessionContext.addSender(sender, senderContext);
                            if (senderConsumer != null) {
                                senderConsumer.accept(sender);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                });
            }
            catch (Exception e) {
                this.error(e);
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
        });
    }

    public void error(Throwable e) {
        this.error(e, 0);
    }

    public void runtimeError(Throwable error) {
        this.error(error, 0);
    }

    public void connectError(Throwable error) {
        this.error(error, this.lastRetryCounter);
    }

    protected void error(Throwable e, int retryCounter) {
        this.retryCounter = retryCounter;
        this.connecting = false;
        logger.warn(e.getMessage(), e);
        this.redoConnection();
    }

    public void disconnect() throws Exception {
        this.redoConnection();
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    public void connectionDestroyed(Object connectionID, boolean failed) {
        this.server.getRemotingService().removeConnection(connectionID);
        this.redoConnection();
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        this.redoConnection();
    }

    private void redoConnection() {
        AMQPFederationSource federation;
        ActiveMQProtonRemotingConnection remotingConnection = this.protonRemotingConnection;
        if (remotingConnection != null) {
            remotingConnection.getAmqpConnection().clearLinkRemoteCloseListeners();
        }
        if ((federation = this.brokerFederation) != null) {
            try {
                federation.connectionInterrupted();
            }
            catch (ActiveMQException e) {
                logger.debug("Broker Federation on connection {} threw an error on stop before connection attempt", (Object)this.getName());
            }
        }
        if (this.bridgeManagers != null) {
            this.bridgeManagers.connectionInterrupted();
        }
        this.connectExecutor.execute(() -> {
            if (this.connecting) {
                logger.debug("Broker connection {} was already in retry mode, exception or retry not captured", (Object)this.getName());
                return;
            }
            this.connecting = true;
            try {
                if (this.protonRemotingConnection != null) {
                    this.protonRemotingConnection.fail(new ActiveMQException("Connection being recreated"));
                    this.connection = null;
                    this.protonRemotingConnection = null;
                }
            }
            catch (Throwable e) {
                logger.warn(e.getMessage(), e);
            }
            this.retryConnection();
        });
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        this.protonRemotingConnection.flush();
    }

    public static boolean isCoreMessageTunnelingEnabled(AMQPMirrorBrokerConnectionElement configuration) {
        Object property = configuration.getProperties().get("tunnel-core-messages");
        if (property instanceof Boolean) {
            Boolean booleanValue = (Boolean)property;
            return booleanValue;
        }
        if (property instanceof String) {
            String string = (String)property;
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    private static final class SaslFactory
    implements ClientSASLFactory {
        private final NettyConnection connection;
        private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;
        private final String[] enabledSaslMechanisms;

        SaslFactory(NettyConnection connection, AMQPBrokerConnectConfiguration brokerConnectConfiguration, String[] enabledSaslMechanisms) {
            this.connection = connection;
            this.brokerConnectConfiguration = brokerConnectConfiguration;
            this.enabledSaslMechanisms = enabledSaslMechanisms;
        }

        @Override
        public ClientSASL chooseMechanism(String[] offeredMechanisms) {
            Set<String> offeredMechanismsSet = this.filterOfferedMechanisms(offeredMechanisms, this.enabledSaslMechanisms);
            if (offeredMechanismsSet.contains(AMQPBrokerConnection.EXTERNAL) && ExternalSASLMechanism.isApplicable(this.connection)) {
                return new ExternalSASLMechanism();
            }
            if (SCRAMClientSASL.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                for (SCRAM scram : SCRAM.values()) {
                    if (!offeredMechanismsSet.contains(scram.getName())) continue;
                    return new SCRAMClientSASL(scram, this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
                }
            }
            if (offeredMechanismsSet.contains(AMQPBrokerConnection.PLAIN) && PlainSASLMechanism.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                return new PlainSASLMechanism(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
            }
            if (offeredMechanismsSet.contains(AMQPBrokerConnection.XOAUTH2) && XOAuth2SASLMechanism.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                return new XOAuth2SASLMechanism(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
            }
            if (offeredMechanismsSet.contains(AMQPBrokerConnection.ANONYMOUS)) {
                return new AnonymousSASLMechanism();
            }
            return null;
        }

        private Set<String> filterOfferedMechanisms(String[] offeredSaslMechanisms, String[] enabledSaslMechanisms) {
            HashSet<String> offeredSaslMechanismsSet;
            HashSet<String> hashSet = offeredSaslMechanismsSet = offeredSaslMechanisms == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(offeredSaslMechanisms));
            if (enabledSaslMechanisms == null || enabledSaslMechanisms.length == 0) {
                return offeredSaslMechanismsSet;
            }
            HashSet<String> enabledSaslMechanismsSet = new HashSet<String>(Arrays.asList(enabledSaslMechanisms));
            enabledSaslMechanismsSet.retainAll(offeredSaslMechanismsSet);
            return enabledSaslMechanismsSet;
        }
    }

    public static class NettyConnectorCloseHandler
    implements FailureListener,
    CloseListener {
        private final NettyConnector connector;
        private final Executor connectionExecutor;

        public NettyConnectorCloseHandler(NettyConnector connector, Executor connectionExecutor) {
            this.connector = connector;
            this.connectionExecutor = connectionExecutor;
        }

        public void connectionClosed() {
            this.doCloseConnector();
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            this.doCloseConnector();
        }

        public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
            this.doCloseConnector();
        }

        private void doCloseConnector() {
            this.connectionExecutor.execute(() -> {
                try {
                    this.connector.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private class AMQPOutgoingController
    implements SenderController {
        final Queue queue;
        final Sender sender;
        final AMQPSessionCallback sessionSPI;
        protected boolean tunnelCoreMessages;
        protected AMQPMessageWriter standardMessageWriter;
        protected AMQPLargeMessageWriter largeMessageWriter;
        protected AMQPTunneledCoreMessageWriter coreMessageWriter;
        protected AMQPTunneledCoreLargeMessageWriter coreLargeMessageWriter;

        AMQPOutgoingController(Queue queue, Sender sender, AMQPSessionCallback sessionSPI) {
            this.queue = queue;
            this.sessionSPI = sessionSPI;
            this.sender = sender;
        }

        @Override
        public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
            SimpleString queueName = this.queue.getName();
            this.tunnelCoreMessages = AmqpSupport.verifyCapabilities(this.sender.getDesiredCapabilities(), AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT) && AmqpSupport.verifyOfferedCapabilities((Link)this.sender, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT);
            return this.sessionSPI.createSender(senderContext, queueName, null, false);
        }

        @Override
        public void close(boolean remoteClose) throws Exception {
        }

        @Override
        public void close(ErrorCondition error) {
            if (this.sender.getRemoteState() != EndpointState.CLOSED) {
                AMQPBrokerConnection.this.runtimeError((Throwable)((Object)new ActiveMQAMQPInternalErrorException("Broker connection mirror consumer locally closed unexpectedly: " + error.getCondition().toString())));
            }
        }

        @Override
        public MessageWriter selectOutgoingMessageWriter(ProtonServerSenderContext sender, MessageReference reference) {
            Message message = reference.getMessage();
            MessageWriter selected = message instanceof AMQPMessage ? (message.isLargeMessage() ? (this.largeMessageWriter != null ? this.largeMessageWriter : (this.largeMessageWriter = new AMQPLargeMessageWriter(sender))) : (this.standardMessageWriter != null ? this.standardMessageWriter : (this.standardMessageWriter = new AMQPMessageWriter(sender)))) : (this.tunnelCoreMessages ? (message.isLargeMessage() ? (this.coreLargeMessageWriter != null ? this.coreLargeMessageWriter : (this.coreLargeMessageWriter = new AMQPTunneledCoreLargeMessageWriter(sender))) : (this.coreMessageWriter != null ? this.coreMessageWriter : (this.coreMessageWriter = new AMQPTunneledCoreMessageWriter(sender)))) : (this.standardMessageWriter != null ? this.standardMessageWriter : (this.standardMessageWriter = new AMQPMessageWriter(sender))));
            return selected;
        }
    }

    private static class XOAuth2SASLMechanism
    implements ClientSASL {
        private final String userName;
        private final String token;

        XOAuth2SASLMechanism(String userName, String token) {
            this.userName = userName;
            this.token = token;
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.XOAUTH2;
        }

        @Override
        public byte[] getInitialResponse() {
            String response = String.format("user=%s\u0001auth=Bearer %s\u0001\u0001", this.userName, this.token);
            return response.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(String username, String password) {
            return username != null && !username.isEmpty() && password != null && !password.isEmpty();
        }
    }

    private static class ExternalSASLMechanism
    implements ClientSASL {
        private ExternalSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.EXTERNAL;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(NettyConnection connection) {
            return CertificateUtil.getLocalPrincipalFromConnection((NettyConnection)connection) != null;
        }
    }

    private static class AnonymousSASLMechanism
    implements ClientSASL {
        private AnonymousSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.ANONYMOUS;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }
    }

    private static class PlainSASLMechanism
    implements ClientSASL {
        private final byte[] initialResponse;

        PlainSASLMechanism(String username, String password) {
            byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            byte[] encoded = new byte[usernameBytes.length + passwordBytes.length + 2];
            System.arraycopy(usernameBytes, 0, encoded, 1, usernameBytes.length);
            System.arraycopy(passwordBytes, 0, encoded, usernameBytes.length + 2, passwordBytes.length);
            this.initialResponse = encoded;
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.PLAIN;
        }

        @Override
        public byte[] getInitialResponse() {
            return this.initialResponse;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(String username, String password) {
            return username != null && !username.isEmpty() && password != null && !password.isEmpty();
        }
    }
}

