/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.scan.ScanRunState;

public abstract class ScanTask<T>
implements Runnable {
    protected final TabletHostingServer server;
    protected AtomicBoolean interruptFlag;
    protected ArrayBlockingQueue<Object> resultQueue;
    protected AtomicInteger state;
    protected AtomicReference<ScanRunState> runState;
    private static final int INITIAL = 1;
    private static final int ADDED = 2;
    private static final int CANCELED = 3;

    ScanTask(TabletHostingServer server) {
        this.server = server;
        this.interruptFlag = new AtomicBoolean(false);
        this.runState = new AtomicReference<ScanRunState>(ScanRunState.QUEUED);
        this.state = new AtomicInteger(1);
        this.resultQueue = new ArrayBlockingQueue(1);
    }

    protected boolean transitionToRunning() {
        return this.runState.compareAndSet(ScanRunState.QUEUED, ScanRunState.RUNNING);
    }

    protected void addResult(Object o) {
        if (this.state.compareAndSet(1, 2)) {
            this.resultQueue.add(o);
        } else if (this.state.get() == 2) {
            throw new IllegalStateException("Tried to add more than one result");
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning) {
            throw new IllegalArgumentException("Cancel will always attempt to interrupt running next batch task");
        }
        if (this.state.get() == 3) {
            return true;
        }
        if (this.state.compareAndSet(1, 3)) {
            this.interruptFlag.set(true);
            this.resultQueue = null;
            return true;
        }
        return false;
    }

    private String stateString(int state) {
        String stateStr;
        switch (state) {
            case 2: {
                stateStr = "ADDED";
                break;
            }
            case 3: {
                stateStr = "CANCELED";
                break;
            }
            case 1: {
                stateStr = "INITIAL";
                break;
            }
            default: {
                stateStr = "UNKNOWN";
            }
        }
        return stateStr;
    }

    public T get(long busyTimeout, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object r;
        ArrayBlockingQueue<Object> localRQ = this.resultQueue;
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (localRQ == null) {
            int st = this.state.get();
            throw new IllegalStateException("Tried to get result twice [state=" + this.stateString(st) + "(" + st + ")]");
        }
        if (busyTimeout > 0L && this.runState.get() == ScanRunState.QUEUED) {
            r = localRQ.poll(busyTimeout, unit);
            if (r == null) {
                if (this.runState.compareAndSet(ScanRunState.QUEUED, ScanRunState.FINISHED)) {
                    this.state.compareAndSet(1, 3);
                    if (this.state.get() != 3) {
                        throw new IllegalStateException("Scan task is in unexpected state " + this.stateString(this.state.get()));
                    }
                } else {
                    long waitTime = Math.max(0L, timeout - busyTimeout);
                    r = localRQ.poll(waitTime, unit);
                }
            }
        } else {
            r = localRQ.poll(timeout, unit);
        }
        if (this.isCancelled()) {
            if (r != null) {
                throw new IllegalStateException("Nothing should have been added when in canceled state");
            }
            throw new CancellationException();
        }
        if (r == null) {
            throw new TimeoutException();
        }
        this.resultQueue = null;
        if (r instanceof Throwable) {
            throw new ExecutionException((Throwable)r);
        }
        Object rAsT = r;
        return (T)rAsT;
    }

    public boolean isCancelled() {
        return this.state.get() == 3;
    }

    public ScanRunState getScanRunState() {
        return this.runState.get();
    }
}

