/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.server.fs.TooManyFilesException;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.SingleScanSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.TabletBase;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextBatchTask
extends ScanTask<ScanBatch> {
    private static final Logger log = LoggerFactory.getLogger(NextBatchTask.class);
    private final long scanID;

    public NextBatchTask(TabletHostingServer server, long scanID, AtomicBoolean interruptFlag) {
        super(server);
        this.scanID = scanID;
        this.interruptFlag = interruptFlag;
        if (interruptFlag.get()) {
            this.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SingleScanSession scanSession = (SingleScanSession)this.server.getSession(this.scanID);
        String oldThreadName = Thread.currentThread().getName();
        try {
            if (this.isCancelled() || scanSession == null) {
                return;
            }
            if (!this.transitionToRunning()) {
                return;
            }
            Thread.currentThread().setName("User: " + scanSession.getUser() + " Start: " + scanSession.startTime + " Client: " + scanSession.client + " Tablet: " + scanSession.extent);
            TabletBase tablet = scanSession.getTabletResolver().getTablet(scanSession.extent);
            if (tablet == null) {
                this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
                return;
            }
            ScanBatch batch = scanSession.scanner.read();
            this.addResult(batch);
        }
        catch (TabletClosedException e) {
            this.addResult(new NotServingTabletException(scanSession.extent.toThrift()));
        }
        catch (IterationInterruptedException iie) {
            if (!this.isCancelled()) {
                log.warn("Iteration interrupted, when scan not cancelled", (Throwable)iie);
                this.addResult((Object)iie);
            }
        }
        catch (SampleNotPresentException | TooManyFilesException e) {
            this.addResult(e);
        }
        catch (IOException | RuntimeException e) {
            log.warn("exception while scanning tablet {} for {}", new Object[]{scanSession.extent, scanSession.client, e});
            this.addResult(e);
        }
        finally {
            this.runState.set(ScanRunState.FINISHED);
            Thread.currentThread().setName(oldThreadName);
        }
    }
}

