/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.compactions.CompactionManager;
import org.apache.accumulo.tserver.tablet.Tablet;

public class TabletServerMetricsUtil {
    private final TabletServer tserver;

    public TabletServerMetricsUtil(TabletServer tserver) {
        this.tserver = tserver;
    }

    public long getLongTabletAssignments() {
        return TabletServerResourceManager.AssignmentWatcher.getLongAssignments();
    }

    public long getEntries() {
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            result += tablet.getNumEntries();
        }
        return result;
    }

    public long getEntriesInMemory() {
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            result += tablet.getNumEntriesInMemory();
        }
        return result;
    }

    public double getIngestCount() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            result += (double)tablet.totalIngest();
        }
        return result;
    }

    public double getIngestByteCount() {
        double result = 0.0;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            result += (double)tablet.totalIngestBytes();
        }
        return result;
    }

    public int getMajorCompactions() {
        CompactionManager mgr = this.tserver.getCompactionManager();
        return mgr == null ? 0 : mgr.getCompactionsRunning();
    }

    public int getMajorCompactionsQueued() {
        CompactionManager mgr = this.tserver.getCompactionManager();
        return mgr == null ? 0 : mgr.getCompactionsQueued();
    }

    public int getMinorCompactions() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            if (!tablet.isMinorCompactionRunning()) continue;
            ++result;
        }
        return result;
    }

    public int getMinorCompactionsQueued() {
        int result = 0;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            if (!tablet.isMinorCompactionQueued()) continue;
            ++result;
        }
        return result;
    }

    public int getOnlineCount() {
        return this.tserver.getOnlineTablets().size();
    }

    public int getOpeningCount() {
        return this.tserver.getOpeningCount();
    }

    public int getUnopenedCount() {
        return this.tserver.getUnopenedCount();
    }

    public String getName() {
        return this.tserver.getClientAddressString();
    }

    public long getTotalMinorCompactions() {
        return this.tserver.getTotalMinorCompactions();
    }

    public double getHoldTime() {
        return this.tserver.getHoldTimeMillis() / 1000.0;
    }

    public double getAverageFilesPerTablet() {
        int count = 0;
        long result = 0L;
        for (Tablet tablet : this.tserver.getOnlineTablets().values()) {
            result += (long)tablet.getDatafiles().size();
            ++count;
        }
        if (count == 0) {
            return 0.0;
        }
        return (double)result / (double)count;
    }
}

