/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.managermessage;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.TabletSplit;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.tserver.managermessage.ManagerMessage;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

public class SplitReportMessage
implements ManagerMessage {
    private Map<KeyExtent, Text> extents;
    private KeyExtent old_extent;

    public SplitReportMessage(KeyExtent old_extent, KeyExtent ne1, Text np1, KeyExtent ne2, Text np2) {
        this.old_extent = old_extent;
        this.extents = new TreeMap<KeyExtent, Text>();
        this.extents.put(ne1, np1);
        this.extents.put(ne2, np2);
    }

    @Override
    public void send(TCredentials credentials, String serverName, ManagerClientService.Iface client) throws TException, ThriftSecurityException {
        TabletSplit split = new TabletSplit();
        split.oldTablet = this.old_extent.toThrift();
        split.newTablets = this.extents.keySet().stream().map(KeyExtent::toThrift).collect(Collectors.toList());
        client.reportSplitExtent(TraceUtil.traceInfo(), credentials, serverName, split);
    }
}

