/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.quantiles.ItemsMergeImpl;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsSketchSortedViewIterator;
import org.apache.datasketches.quantiles.ItemsUtil;
import org.apache.datasketches.quantilescommon.GenericInequalitySearch;
import org.apache.datasketches.quantilescommon.GenericSortedView;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public final class ItemsSketchSortedView<T>
implements GenericSortedView<T> {
    private final T[] quantiles;
    private final long[] cumWeights;
    private final long totalN;
    private final Comparator<? super T> comparator;

    ItemsSketchSortedView(T[] quantiles, long[] cumWeights, long totalN, Comparator<T> comparator) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
        this.comparator = comparator;
    }

    ItemsSketchSortedView(ItemsSketch<T> sketch) {
        this.totalN = sketch.getN();
        int k = sketch.getK();
        int numQuantiles = sketch.getNumRetained();
        this.quantiles = (Object[])Array.newInstance(sketch.clazz, numQuantiles);
        this.cumWeights = new long[numQuantiles];
        this.comparator = sketch.getComparator();
        Object[] combinedBuffer = sketch.getCombinedBuffer();
        int baseBufferCount = sketch.getBaseBufferCount();
        ItemsSketchSortedView.populateFromItemsSketch(k, this.totalN, sketch.getBitPattern(), combinedBuffer, baseBufferCount, numQuantiles, this.quantiles, this.cumWeights, sketch.getComparator());
        ItemsMergeImpl.blockyTandemMergeSort(this.quantiles, this.cumWeights, numQuantiles, k, sketch.getComparator());
        if (ItemsSketchSortedView.convertToCumulative(this.cumWeights) != this.totalN) {
            throw new SketchesStateException("Sorted View is misconfigured. TotalN does not match cumWeights.");
        }
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        long naturalRank = (int)(rank * (double)this.totalN);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[this.quantiles.length - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        int len = this.quantiles.length;
        GenericInequalitySearch.Inequality crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? GenericInequalitySearch.Inequality.LE : GenericInequalitySearch.Inequality.LT;
        int index = GenericInequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit, this.comparator);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        ItemsUtil.validateItems(splitPoints, this.comparator);
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        int len;
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        ItemsUtil.validateItems(splitPoints, this.comparator);
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = len = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public T[] getQuantiles() {
        return (Object[])this.quantiles.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public ItemsSketchSortedViewIterator<T> iterator() {
        return new ItemsSketchSortedViewIterator(this.quantiles, this.cumWeights);
    }

    private static final <T> void populateFromItemsSketch(int k, long n, long bitPattern, T[] combinedBuffer, int baseBufferCount, int numQuantiles, T[] quantilesArr, long[] weightsArr, Comparator<? super T> comparator) {
        long bits;
        long weight = 1L;
        int nxt = 0;
        assert (bits == n / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight *= 2L;
            if ((bits & 1L) > 0L) {
                int offset = (2 + lvl) * k;
                for (int i = 0; i < k; ++i) {
                    quantilesArr[nxt] = combinedBuffer[i + offset];
                    weightsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        for (int i = 0; i < baseBufferCount; ++i) {
            quantilesArr[nxt] = combinedBuffer[i];
            weightsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == numQuantiles);
        Arrays.sort(quantilesArr, startOfBaseBufferBlock, numQuantiles, comparator);
    }

    private static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }
}

