/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DUCommand
extends Shell.Command {
    private Option optTablePattern;
    private Option optHumanReadble;
    private Option optNamespace;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, TableNotFoundException, NamespaceNotFoundException {
        TreeSet<String> tables = new TreeSet<String>(Arrays.asList(cl.getArgs()));
        if (cl.hasOption("t")) {
            tables.add(cl.getOptionValue("t"));
        }
        if (cl.hasOption(this.optNamespace.getOpt())) {
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)shellState.getContext(), (String)cl.getOptionValue(this.optNamespace.getOpt()));
            tables.addAll(Namespaces.getTableNames((ClientContext)shellState.getContext(), (NamespaceId)namespaceId));
        }
        boolean prettyPrint = cl.hasOption(this.optHumanReadble.getOpt());
        if (cl.hasOption(this.optTablePattern.getOpt())) {
            shellState.getAccumuloClient().tableOperations().list().stream().filter(Pattern.compile(cl.getOptionValue(this.optTablePattern.getOpt())).asMatchPredicate()).forEach(tables::add);
        }
        if (tables.isEmpty() && !shellState.getTableName().isEmpty()) {
            tables.add(shellState.getTableName());
        }
        for (String tableName : tables) {
            if (shellState.getAccumuloClient().tableOperations().exists(tableName)) continue;
            throw new TableNotFoundException(tableName, tableName, "specified table that doesn't exist");
        }
        try {
            String valueFormat = prettyPrint ? "%9s" : "%,24d";
            for (DiskUsage usage : shellState.getAccumuloClient().tableOperations().getDiskUsage(tables)) {
                Object value = prettyPrint ? NumUtil.bigNumberForSize((long)usage.getUsage()) : Long.valueOf(usage.getUsage());
                shellState.getWriter().println(String.format(valueFormat + " %s", value, usage.getTables()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return 0;
    }

    @Override
    public String description() {
        return "Prints estimated space, in bytes, used by files referenced by a table or tables.  When multiple tables are specified it prints how much space, in bytes, are used by files shared between tables, if any. Because the metadata table is used for the file size information and not the actual files in HDFS the results will be an estimate. Older entries may exist with no file metadata (resulting in size 0) and other actions in the cluster can impact the estimated size such as flushes, tablet splits, compactions, etc. For more accurate information a compaction should first be run on all of the files for the set of tables being computed.";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.optTablePattern = new Option("p", "pattern", true, "regex pattern of table names");
        this.optTablePattern.setArgName("pattern");
        this.optHumanReadble = new Option("h", "human-readable", false, "format large sizes to human readable units");
        this.optHumanReadble.setArgName("human readable output");
        this.optNamespace = new Option("ns", "namespace", true, "name of a namespace");
        this.optNamespace.setArgName("namespace");
        o.addOption(OptUtil.tableOpt("table to examine"));
        o.addOption(this.optTablePattern);
        o.addOption(this.optHumanReadble);
        o.addOption(this.optNamespace);
        return o;
    }

    @Override
    public String usage() {
        return this.getName() + " <table>{ <table>}";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

