/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionFinalState;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.tabletserver.thrift.TabletServerClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionFinalizer {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionFinalizer.class);
    protected final ServerContext context;
    private final ExecutorService ntfyExecutor;
    private final ExecutorService backgroundExecutor;
    private final BlockingQueue<ExternalCompactionFinalState> pendingNotifications;
    private final long tserverCheckInterval;

    protected CompactionFinalizer(ServerContext context, ScheduledThreadPoolExecutor schedExecutor) {
        this.context = context;
        this.pendingNotifications = new ArrayBlockingQueue<ExternalCompactionFinalState>(1000);
        this.tserverCheckInterval = this.context.getConfiguration().getTimeInMillis(Property.COMPACTION_COORDINATOR_FINALIZER_COMPLETION_CHECK_INTERVAL);
        int max = this.context.getConfiguration().getCount(Property.COMPACTION_COORDINATOR_FINALIZER_TSERVER_NOTIFIER_MAXTHREADS);
        this.ntfyExecutor = ThreadPools.getServerThreadPools().createThreadPool(3, max, 1L, TimeUnit.MINUTES, "Compaction Finalizer Notifier", true);
        this.backgroundExecutor = ThreadPools.getServerThreadPools().createFixedThreadPool(1, "Compaction Finalizer Background Task", true);
        this.backgroundExecutor.execute(() -> this.processPending());
        ThreadPools.watchCriticalScheduledTask(schedExecutor.scheduleWithFixedDelay(this::notifyTservers, 0L, this.tserverCheckInterval, TimeUnit.MILLISECONDS));
    }

    public void commitCompaction(ExternalCompactionId ecid, KeyExtent extent, long fileSize, long fileEntries) {
        ExternalCompactionFinalState ecfs = new ExternalCompactionFinalState(ecid, extent, ExternalCompactionFinalState.FinalState.FINISHED, fileSize, fileEntries);
        LOG.debug("Initiating commit for external compaction: {}", (Object)ecfs);
        this.context.getAmple().putExternalCompactionFinalStates(List.of(ecfs));
        if (!this.pendingNotifications.offer(ecfs)) {
            LOG.debug("Queue full, notification to tablet server will happen later {}.", (Object)ecfs);
        } else {
            LOG.debug("Queued tserver notification for completed external compaction: {}", (Object)ecfs);
        }
    }

    public void failCompactions(Map<ExternalCompactionId, KeyExtent> compactionsToFail) {
        List<ExternalCompactionFinalState> finalStates = compactionsToFail.entrySet().stream().map(e -> new ExternalCompactionFinalState((ExternalCompactionId)e.getKey(), (KeyExtent)e.getValue(), ExternalCompactionFinalState.FinalState.FAILED, 0L, 0L)).collect(Collectors.toList());
        this.context.getAmple().putExternalCompactionFinalStates(finalStates);
        finalStates.forEach(this.pendingNotifications::offer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTserver(TabletMetadata.Location loc, ExternalCompactionFinalState ecfs) {
        TabletServerClientService.Client client;
        block6: {
            client = null;
            try {
                client = (TabletServerClientService.Client)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)loc.getHostAndPort(), (ClientContext)this.context);
                if (ecfs.getFinalState() == ExternalCompactionFinalState.FinalState.FINISHED) {
                    LOG.debug("Notifying tserver {} that compaction {} has finished.", (Object)loc, (Object)ecfs);
                    client.compactionJobFinished(TraceUtil.traceInfo(), this.context.rpcCreds(), ecfs.getExternalCompactionId().canonical(), ecfs.getExtent().toThrift(), ecfs.getFileSize(), ecfs.getEntries());
                    break block6;
                }
                if (ecfs.getFinalState() == ExternalCompactionFinalState.FinalState.FAILED) {
                    LOG.debug("Notifying tserver {} that compaction {} has failed.", (Object)loc, (Object)ecfs);
                    client.compactionJobFailed(TraceUtil.traceInfo(), this.context.rpcCreds(), ecfs.getExternalCompactionId().canonical(), ecfs.getExtent().toThrift());
                    break block6;
                }
                throw new IllegalArgumentException(ecfs.getFinalState().name());
            }
            catch (TException e) {
                try {
                    LOG.warn("Failed to notify tserver {}", (Object)loc.getHostAndPort(), (Object)e);
                }
                catch (Throwable throwable) {
                    ThriftUtil.returnClient(client, (ClientContext)this.context);
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.context);
            }
        }
        ThriftUtil.returnClient((TServiceClient)client, (ClientContext)this.context);
    }

    private void processPending() {
        while (!Thread.interrupted()) {
            try {
                Map tabletsMetadata;
                ArrayList<ExternalCompactionFinalState> batch = new ArrayList<ExternalCompactionFinalState>();
                batch.add(this.pendingNotifications.take());
                this.pendingNotifications.drainTo(batch);
                ArrayList futures = new ArrayList();
                ArrayList<ExternalCompactionId> statusesToDelete = new ArrayList<ExternalCompactionId>();
                List extents = batch.stream().map(ExternalCompactionFinalState::getExtent).collect(Collectors.toList());
                try (TabletsMetadata tablets = this.context.getAmple().readTablets().forTablets(extents, Optional.empty()).fetch(new TabletMetadata.ColumnType[]{TabletMetadata.ColumnType.LOCATION, TabletMetadata.ColumnType.PREV_ROW, TabletMetadata.ColumnType.ECOMP}).build();){
                    tabletsMetadata = tablets.stream().collect(Collectors.toMap(TabletMetadata::getExtent, Function.identity()));
                }
                for (ExternalCompactionFinalState externalCompactionFinalState : batch) {
                    TabletMetadata tabletMetadata = (TabletMetadata)tabletsMetadata.get(externalCompactionFinalState.getExtent());
                    if (tabletMetadata == null || !tabletMetadata.getExternalCompactions().keySet().contains(externalCompactionFinalState.getExternalCompactionId())) {
                        LOG.debug("Unable to find tablets external compaction entry, deleting completion entry {}", (Object)externalCompactionFinalState);
                        statusesToDelete.add(externalCompactionFinalState.getExternalCompactionId());
                        continue;
                    }
                    if (tabletMetadata.getLocation() != null && tabletMetadata.getLocation().getType() == TabletMetadata.LocationType.CURRENT) {
                        futures.add(this.ntfyExecutor.submit(() -> this.notifyTserver(tabletMetadata.getLocation(), ecfs)));
                        continue;
                    }
                    LOG.trace("External compaction {} is completed, but there is no location for tablet.  Unable to notify tablet, will try again later.", (Object)externalCompactionFinalState);
                }
                if (!statusesToDelete.isEmpty()) {
                    LOG.info("Deleting unresolvable completed external compactions from metadata table, ids: {}", statusesToDelete);
                    this.context.getAmple().deleteExternalCompactionFinalStates(statusesToDelete);
                }
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        LOG.debug("Failed to notify tserver", (Throwable)e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to process pending notifications", (Throwable)e);
            }
        }
    }

    private void notifyTservers() {
        try {
            Iterator finalStates = this.context.getAmple().getExternalCompactionFinalStates().iterator();
            while (finalStates.hasNext()) {
                ExternalCompactionFinalState state = (ExternalCompactionFinalState)finalStates.next();
                LOG.debug("Found external compaction in final state: {}, queueing for tserver notification", (Object)state);
                this.pendingNotifications.put(state);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify tservers", (Throwable)e);
        }
    }
}

