/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;

public final class PropUtil {
    private PropUtil() {
    }

    public static void setProperties(ServerContext context, PropStoreKey<?> propStoreKey, Map<String, String> properties) throws IllegalArgumentException {
        PropUtil.validateProperties(propStoreKey, properties);
        context.getPropStore().putAll(propStoreKey, properties);
    }

    public static void removeProperties(ServerContext context, PropStoreKey<?> propStoreKey, Collection<String> propertyNames) {
        context.getPropStore().removeProperties(propStoreKey, propertyNames);
    }

    public static void replaceProperties(ServerContext context, PropStoreKey<?> propStoreKey, long version, Map<String, String> properties) throws IllegalArgumentException {
        PropUtil.validateProperties(propStoreKey, properties);
        context.getPropStore().replaceAll(propStoreKey, version, properties);
    }

    protected static void validateProperties(PropStoreKey<?> propStoreKey, Map<String, String> properties) throws IllegalArgumentException {
        for (Map.Entry<String, String> prop : properties.entrySet()) {
            if (!Property.isValidProperty((String)prop.getKey(), (String)prop.getValue())) {
                String exceptionMessage = "Invalid property for : ";
                if (!Property.isValidTablePropertyKey((String)prop.getKey())) {
                    exceptionMessage = "Invalid Table property for : ";
                }
                throw new IllegalArgumentException(exceptionMessage + propStoreKey + " name: " + prop.getKey() + ", value: " + prop.getValue());
            }
            if (!prop.getKey().equals(Property.TABLE_CLASSLOADER_CONTEXT.getKey()) || Property.TABLE_CLASSLOADER_CONTEXT.getDefaultValue().equals(prop.getValue()) || ClassLoaderUtil.isValidContext((String)prop.getValue())) continue;
            throw new IllegalArgumentException("Unable to resolve classloader for context: " + prop.getValue());
        }
    }
}

