/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ChangeSecret {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ServerContext context, AccumuloConfiguration conf) throws Exception {
        try (VolumeManager fs = context.getVolumeManager();){
            ServerDirs serverDirs = new ServerDirs(conf, new Configuration());
            ChangeSecret.verifyHdfsWritePermission(serverDirs, fs);
            String oldPass = String.valueOf(System.console().readPassword("Old secret: ", new Object[0]));
            String newPass = String.valueOf(System.console().readPassword("New secret: ", new Object[0]));
            Span span = TraceUtil.startSpan(ChangeSecret.class, (String)"main");
            try (Scope scope = span.makeCurrent();){
                ChangeSecret.verifyAccumuloIsDown(context, oldPass);
                InstanceId newInstanceId = InstanceId.of((UUID)UUID.randomUUID());
                ChangeSecret.updateHdfs(serverDirs, fs, newInstanceId);
                ChangeSecret.rewriteZooKeeperInstance(context, newInstanceId, oldPass, newPass);
                if (!StringUtils.isBlank((CharSequence)oldPass)) {
                    ChangeSecret.deleteInstance(context, oldPass);
                }
                System.out.println("New instance id is " + newInstanceId);
                System.out.println("Be sure to put your new secret in accumulo.properties");
            }
            finally {
                span.end();
            }
        }
    }

    private static void recurse(ZooReader zoo, String root, Visitor v) {
        try {
            v.visit(zoo, root);
            for (String child : zoo.getChildren(root)) {
                ChangeSecret.recurse(zoo, root + "/" + child, v);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void verifyAccumuloIsDown(ServerContext context, String oldPassword) throws Exception {
        ZooReaderWriter zooReader = context.getZooReader().asWriter(oldPassword);
        String root = context.getZooKeeperRoot();
        ArrayList ephemerals = new ArrayList();
        ChangeSecret.recurse((ZooReader)zooReader, root, (zoo, path) -> {
            Stat stat = zoo.getStatus(path);
            if (stat.getEphemeralOwner() != 0L) {
                ephemerals.add(path);
            }
        });
        if (!ephemerals.isEmpty()) {
            System.err.println("The following ephemeral nodes exist, something is still running:");
            for (String path2 : ephemerals) {
                System.err.println(path2);
            }
            throw new Exception("Accumulo must be shut down in order to run this tool.");
        }
    }

    private static void rewriteZooKeeperInstance(ServerContext context, InstanceId newInstanceId, String oldPass, String newPass) throws Exception {
        ZooReaderWriter orig = context.getZooReader().asWriter(oldPass);
        ZooReaderWriter new_ = context.getZooReader().asWriter(newPass);
        String root = context.getZooKeeperRoot();
        ChangeSecret.recurse((ZooReader)orig, root, (zoo, path) -> {
            String newPath = path.replace(context.getInstanceID().canonical(), newInstanceId.canonical());
            byte[] data = zoo.getData(path);
            List acls = orig.getZooKeeper().getACL(path, new Stat());
            if (acls.containsAll(ZooDefs.Ids.READ_ACL_UNSAFE)) {
                new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
            } else if (acls.containsAll(ZooDefs.Ids.OPEN_ACL_UNSAFE)) {
                String[] parts = path.split("/");
                if (parts[parts.length - 2].equals("users")) {
                    new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                } else {
                    new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                }
            } else {
                new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
            }
        });
        String path2 = "/accumulo/instances/" + context.getInstanceName();
        orig.recursiveDelete(path2, ZooUtil.NodeMissingPolicy.SKIP);
        new_.putPersistentData(path2, newInstanceId.canonical().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    private static void updateHdfs(ServerDirs serverDirs, VolumeManager fs, InstanceId newInstanceId) throws IOException {
        for (Volume v : fs.getVolumes()) {
            Path instanceId = serverDirs.getInstanceIdLocation(v);
            if (!v.getFileSystem().delete(instanceId, true)) {
                throw new IOException("Could not recursively delete " + instanceId);
            }
            if (!v.getFileSystem().mkdirs(instanceId)) {
                throw new IOException("Could not create directory " + instanceId);
            }
            v.getFileSystem().create(new Path(instanceId, newInstanceId.canonical())).close();
        }
    }

    private static void verifyHdfsWritePermission(ServerDirs serverDirs, VolumeManager fs) throws Exception {
        for (Volume v : fs.getVolumes()) {
            Path instanceId = serverDirs.getInstanceIdLocation(v);
            FileStatus fileStatus = v.getFileSystem().getFileStatus(instanceId);
            ChangeSecret.checkHdfsAccessPermissions(fileStatus, FsAction.WRITE);
        }
    }

    private static void checkHdfsAccessPermissions(FileStatus stat, FsAction mode) throws Exception {
        FsPermission perm = stat.getPermission();
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getShortUserName();
        List<String> groups = Arrays.asList(ugi.getGroupNames());
        if (user.equals(stat.getOwner()) ? perm.getUserAction().implies(mode) : (groups.contains(stat.getGroup()) ? perm.getGroupAction().implies(mode) : perm.getOtherAction().implies(mode))) {
            return;
        }
        throw new Exception(String.format("Permission denied: user=%s, path=\"%s\":%s:%s:%s%s", user, stat.getPath(), stat.getOwner(), stat.getGroup(), stat.isDirectory() ? "d" : "-", perm));
    }

    private static void deleteInstance(ServerContext context, String oldPass) throws Exception {
        ZooReaderWriter orig = context.getZooReader().asWriter(oldPass);
        orig.recursiveDelete("/accumulo/" + context.getInstanceID(), ZooUtil.NodeMissingPolicy.SKIP);
    }

    static interface Visitor {
        public void visit(ZooReader var1, String var2) throws Exception;
    }
}

