/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.mem;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowMemoryDetector {
    private static final Logger LOG = LoggerFactory.getLogger(LowMemoryDetector.class);
    private final HashMap<String, Long> prevGcTime = new HashMap();
    private long lastMemorySize = 0L;
    private int lowMemCount = 0;
    private long lastMemoryCheckTime = 0L;
    private final Lock memCheckTimeLock = new ReentrantLock();
    private volatile boolean runningLowOnMemory = false;

    public long getIntervalMillis(AccumuloConfiguration conf) {
        return conf.getTimeInMillis(Property.GENERAL_LOW_MEM_DETECTOR_INTERVAL);
    }

    public boolean isRunningLowOnMemory() {
        return this.runningLowOnMemory;
    }

    public boolean isRunningLowOnMemory(ServerContext context, DetectionScope scope, Supplier<Boolean> isUserTable, Action action) {
        if (isUserTable.get().booleanValue()) {
            Property p;
            switch (scope) {
                case SCAN: {
                    p = Property.GENERAL_LOW_MEM_SCAN_PROTECTION;
                    break;
                }
                case MINC: {
                    p = Property.GENERAL_LOW_MEM_MINC_PROTECTION;
                    break;
                }
                case MAJC: {
                    p = Property.GENERAL_LOW_MEM_MAJC_PROTECTION;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown scope: " + scope);
                }
            }
            boolean isEnabled = context.getConfiguration().getBoolean(p);
            if (isEnabled && this.runningLowOnMemory) {
                action.execute();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logGCInfo(AccumuloConfiguration conf) {
        double freeMemoryPercentage = conf.getFraction(Property.GENERAL_LOW_MEM_DETECTOR_THRESHOLD);
        this.memCheckTimeLock.lock();
        try {
            long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            StringBuilder sb = new StringBuilder("gc");
            boolean sawChange = false;
            long maxIncreaseInCollectionTime = 0L;
            for (GarbageCollectorMXBean gcBean : gcmBeans) {
                long time;
                Long prevTime = this.prevGcTime.get(gcBean.getName());
                long pt = 0L;
                if (prevTime != null) {
                    pt = prevTime;
                }
                if ((time = gcBean.getCollectionTime()) - pt != 0L) {
                    sawChange = true;
                }
                long increaseInCollectionTime = time - pt;
                sb.append(String.format(" %s=%,.2f(+%,.2f) secs", gcBean.getName(), (double)time / 1000.0, (double)increaseInCollectionTime / 1000.0));
                maxIncreaseInCollectionTime = Math.max(increaseInCollectionTime, maxIncreaseInCollectionTime);
                this.prevGcTime.put(gcBean.getName(), time);
            }
            Runtime rt = Runtime.getRuntime();
            long maxConfiguredMemory = rt.maxMemory();
            long allocatedMemory = rt.totalMemory();
            long allocatedFreeMemory = rt.freeMemory();
            long freeMemory = maxConfiguredMemory - (allocatedMemory - allocatedFreeMemory);
            long lowMemoryThreshold = (long)((double)maxConfiguredMemory * freeMemoryPercentage);
            LOG.trace("Memory info: max={}, allocated={}, free={}, free threshold={}", new Object[]{maxConfiguredMemory, allocatedMemory, freeMemory, lowMemoryThreshold});
            if (freeMemory < lowMemoryThreshold) {
                ++this.lowMemCount;
                if (this.lowMemCount > 3 && !this.runningLowOnMemory) {
                    this.runningLowOnMemory = true;
                    LOG.warn("Running low on memory: max={}, allocated={}, free={}, free threshold={}", new Object[]{maxConfiguredMemory, allocatedMemory, freeMemory, lowMemoryThreshold});
                }
            } else {
                if (this.runningLowOnMemory) {
                    LOG.warn("Recovered from low memory condition");
                } else {
                    LOG.trace("Not running low on memory");
                }
                this.runningLowOnMemory = false;
                this.lowMemCount = 0;
            }
            if (freeMemory != this.lastMemorySize) {
                sawChange = true;
            }
            sb.append(String.format(" freemem=%,d(%+,d) totalmem=%,d", freeMemory, freeMemory - this.lastMemorySize, rt.totalMemory()));
            if (sawChange) {
                LOG.debug(sb.toString());
            }
            long keepAliveTimeout = conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
            if (this.lastMemoryCheckTime > 0L && this.lastMemoryCheckTime < now) {
                long diff = now - this.lastMemoryCheckTime;
                if (diff > keepAliveTimeout + 1000L) {
                    LOG.warn(String.format("GC pause checker not called in a timely fashion. Expected every %.1f seconds but was %.1f seconds since last check", (double)keepAliveTimeout / 1000.0, (double)diff / 1000.0));
                }
                this.lastMemoryCheckTime = now;
                return;
            }
            if (maxIncreaseInCollectionTime > keepAliveTimeout) {
                Halt.halt((String)"Garbage collection may be interfering with lock keep-alive. Halting.", (int)-1);
            }
            this.lastMemorySize = freeMemory;
            this.lastMemoryCheckTime = now;
        }
        finally {
            this.memCheckTimeLock.unlock();
        }
    }

    public static enum DetectionScope {
        MINC,
        MAJC,
        SCAN;

    }

    @FunctionalInterface
    public static interface Action {
        public void execute();
    }
}

