/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropStoreMetrics
implements MetricsProducer {
    private static final Logger log = LoggerFactory.getLogger(PropStoreMetrics.class);
    private Timer load;
    private Counter refresh;
    private Counter refreshLoad;
    private Counter eviction;
    private Counter zkError;

    public void registerMetrics(MeterRegistry registry) {
        this.load = Timer.builder((String)"accumulo.prop.store.load").description("prop store load time").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.refresh = Counter.builder((String)"accumulo.prop.store.refresh").description("prop store refresh count").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.refreshLoad = Counter.builder((String)"accumulo.prop.store.refresh.load").description("prop store refresh load count").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.eviction = Counter.builder((String)"accumulo.prop.store.evictions").description("prop store eviction count").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
        this.zkError = Counter.builder((String)"accumulo.prop.store.zookeeper.error").description("prop store ZooKeeper error count").tags((Iterable)MetricsUtil.getCommonTags()).register(registry);
    }

    public PropStoreMetrics() {
        log.debug("Creating PropStore metrics");
    }

    public void addLoadTime(long value) {
        log.trace("Load time: {}", (Object)value);
        this.load.record(Duration.ofMillis(value));
        log.trace("Load count: {} time:{}", (Object)this.load.count(), (Object)this.load.totalTime(TimeUnit.MILLISECONDS));
    }

    public void incrRefresh() {
        this.refresh.increment();
    }

    public void incrRefreshLoad() {
        this.refreshLoad.increment();
    }

    public void incrEviction() {
        this.eviction.increment();
    }

    public void incrZkError() {
        this.zkError.increment();
    }
}

