/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.tableImport.FinishImportTable;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.manager.tableOps.tableImport.PopulateMetadataTable;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoveExportedFiles
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(MoveExportedFiles.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MoveExportedFiles(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        String fmtTid = FateTxId.formatTid((long)tid);
        int workerCount = manager.getConfiguration().getCount(Property.MANAGER_RENAME_THREADS);
        VolumeManager fs = manager.getVolumeManager();
        HashMap<Path, Path> oldToNewPaths = new HashMap<Path, Path>();
        for (ImportedTableInfo.DirectoryMapping dm : this.tableInfo.directories) {
            Sets.SetView missingFiles;
            HashMap<String, String> fileNameMappings = new HashMap<String, String>();
            PopulateMetadataTable.readMappingFile(fs, this.tableInfo, dm.importDir, fileNameMappings);
            FileStatus[] exportedFiles = fs.listStatus(new Path(dm.exportDir));
            FileStatus[] importedFiles = fs.listStatus(new Path(dm.importDir));
            Function<FileStatus, String> fileStatusName = fstat -> fstat.getPath().getName();
            Set importing = Arrays.stream(exportedFiles).map(fileStatusName).map(fileNameMappings::get).collect(Collectors.toSet());
            Set imported = Arrays.stream(importedFiles).map(fileStatusName).collect(Collectors.toSet());
            if (log.isDebugEnabled()) {
                log.debug("{} files already present in imported (target) directory: {}", (Object)fmtTid, (Object)String.join((CharSequence)",", imported));
            }
            if (!(missingFiles = Sets.difference(new HashSet(fileNameMappings.values()), new HashSet(Sets.union(importing, imported)))).isEmpty()) {
                throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Missing source files corresponding to files " + String.join((CharSequence)",", (Iterable<? extends CharSequence>)missingFiles));
            }
            for (FileStatus fileStatus : exportedFiles) {
                Path originalPath = fileStatus.getPath();
                String newName = (String)fileNameMappings.get(originalPath.getName());
                if (newName != null) {
                    Path newPath = new Path(dm.importDir, newName);
                    oldToNewPaths.put(originalPath, newPath);
                    continue;
                }
                log.debug("{} not moving (unmapped) file {}", (Object)fmtTid, (Object)originalPath);
            }
        }
        try {
            fs.bulkRename(oldToNewPaths, workerCount, "importtable rename", fmtTid);
        }
        catch (IOException ioe) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), null, TableOperation.IMPORT, TableOperationExceptionType.OTHER, ioe.getCause().getMessage());
        }
        return new FinishImportTable(this.tableInfo);
    }
}

