/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;

public class CompactionServicesConfig {
    private final Map<String, String> planners = new HashMap<String, String>();
    private final Map<String, Long> rateLimits = new HashMap<String, Long>();
    private final Map<String, Map<String, String>> options = new HashMap<String, Map<String, String>>();
    long defaultRateLimit;
    public static final CompactionServiceId DEFAULT_SERVICE = CompactionServiceId.of("default");

    private long getDefaultThroughput() {
        return ConfigurationTypeHelper.getMemoryAsBytes(Property.TSERV_COMPACTION_SERVICE_DEFAULT_RATE_LIMIT.getDefaultValue());
    }

    private Map<String, String> getConfiguration(AccumuloConfiguration aconf) {
        return aconf.getAllPropertiesWithPrefix(Property.TSERV_COMPACTION_SERVICE_PREFIX);
    }

    public CompactionServicesConfig(AccumuloConfiguration aconf) {
        Map<String, String> configs = this.getConfiguration(aconf);
        configs.forEach((prop, val) -> {
            String suffix = prop.substring(Property.TSERV_COMPACTION_SERVICE_PREFIX.getKey().length());
            String[] tokens = suffix.split("\\.");
            if (tokens.length == 4 && tokens[1].equals("planner") && tokens[2].equals("opts")) {
                this.options.computeIfAbsent(tokens[0], k -> new HashMap()).put(tokens[3], val);
            } else if (tokens.length == 2 && tokens[1].equals("planner")) {
                this.planners.put(tokens[0], (String)val);
            } else if (tokens.length == 3 && tokens[1].equals("rate") && tokens[2].equals("limit")) {
                Property eprop = Property.getPropertyByKey(prop);
                if (eprop == null || aconf.isPropertySet(eprop)) {
                    this.rateLimits.put(tokens[0], ConfigurationTypeHelper.getFixedMemoryAsBytes(val));
                }
            } else {
                throw new IllegalArgumentException("Malformed compaction service property " + prop);
            }
        });
        this.defaultRateLimit = this.getDefaultThroughput();
        Sets.SetView diff = Sets.difference(this.options.keySet(), this.planners.keySet());
        if (!diff.isEmpty()) {
            throw new IllegalArgumentException("Incomplete compaction service definitions, missing planner class " + diff);
        }
    }

    public long getRateLimit(String serviceName) {
        return this.getRateLimits().getOrDefault(serviceName, this.defaultRateLimit);
    }

    public boolean equals(Object o) {
        if (o instanceof CompactionServicesConfig) {
            CompactionServicesConfig oc = (CompactionServicesConfig)o;
            return this.getPlanners().equals(oc.getPlanners()) && this.getOptions().equals(oc.getOptions()) && this.getRateLimits().equals(oc.getRateLimits());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPlanners(), this.getOptions(), this.getRateLimits());
    }

    public Map<String, String> getPlanners() {
        return this.planners;
    }

    public Map<String, Long> getRateLimits() {
        return this.rateLimits;
    }

    public Map<String, Map<String, String>> getOptions() {
        return this.options;
    }
}

