/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.sample.impl;

import com.google.common.hash.Hasher;
import java.io.DataOutput;
import java.nio.charset.StandardCharsets;

public class DataoutputHasher
implements DataOutput {
    private Hasher hasher;

    public DataoutputHasher(Hasher hasher) {
        this.hasher = hasher;
    }

    @Override
    public void write(int b) {
        this.hasher.putByte((byte)(0xFF & b));
    }

    @Override
    public void write(byte[] b) {
        this.hasher.putBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.hasher.putBytes(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.hasher.putBoolean(v);
    }

    @Override
    public void writeByte(int v) {
        this.hasher.putByte((byte)(0xFF & v));
    }

    @Override
    public void writeShort(int v) {
        this.hasher.putShort((short)(0xFFFF & v));
    }

    @Override
    public void writeChar(int v) {
        this.hasher.putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.hasher.putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.hasher.putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.hasher.putDouble((double)v);
    }

    @Override
    public void writeDouble(double v) {
        this.hasher.putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        for (int i = 0; i < s.length(); ++i) {
            this.hasher.putByte((byte)(0xFF & s.charAt(i)));
        }
    }

    @Override
    public void writeChars(String s) {
        this.hasher.putString((CharSequence)s, StandardCharsets.UTF_8);
    }

    @Override
    public void writeUTF(String s) {
        this.hasher.putInt(s.length());
        this.hasher.putBytes(s.getBytes(StandardCharsets.UTF_8));
    }
}

