/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;

public interface ManagerClient<C extends TServiceClient> {
    default public C getManagerConnection(Logger log, ThriftClientTypes<C> type, ClientContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        List<String> locations = context.getManagerLocations();
        if (locations.isEmpty()) {
            log.debug("No managers...");
            return null;
        }
        HostAndPort manager = HostAndPort.fromString((String)locations.get(0));
        if (manager.getPort() == 0) {
            return null;
        }
        try {
            return ThriftUtil.getClientNoTimeout(type, manager, context);
        }
        catch (TTransportException tte) {
            Throwable cause = tte.getCause();
            if (cause != null && cause instanceof UnknownHostException) {
                throw new IllegalStateException(tte);
            }
            log.debug("Failed to connect to manager=" + manager + ", will retry... ", (Throwable)tte);
            return null;
        }
    }
}

