/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class ProtocolOverridingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;
    private final String[] enabledProtocols;

    public ProtocolOverridingSSLSocketFactory(SSLSocketFactory delegate, String[] enabledProtocols) {
        Objects.requireNonNull(enabledProtocols);
        Preconditions.checkArgument((enabledProtocols.length != 0 ? 1 : 0) != 0, (Object)"Expected at least one protocol");
        this.delegate = delegate;
        this.enabledProtocols = enabledProtocols;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(socket, host, port, autoClose);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.delegate.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket underlyingSocket = this.delegate.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port);
        return this.overrideProtocol(underlyingSocket);
    }

    @Override
    public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket underlyingSocket = this.delegate.createSocket(host, port, localAddress, localPort);
        return this.overrideProtocol(underlyingSocket);
    }

    private Socket overrideProtocol(Socket socket) {
        if (socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(this.enabledProtocols);
        }
        return socket;
    }
}

