/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.AbstractTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.ValidationUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencedTabletFile
extends AbstractTabletFile<ReferencedTabletFile> {
    private final FileParts parts;
    private static final Logger log = LoggerFactory.getLogger(ReferencedTabletFile.class);
    private static final String HDFS_TABLES_DIR_NAME = "/tables".substring(1);

    private static String constructErrorMsg(Path filePath) {
        return "Missing or invalid part of tablet file metadata entry: " + filePath;
    }

    public static FileParts parsePath(Path filePath) {
        URI uri = filePath.toUri();
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (Object)ReferencedTabletFile.constructErrorMsg(filePath));
        String path = uri.getPath();
        String[] parts = path.split("/");
        int numParts = parts.length;
        if (numParts < 4) {
            throw new IllegalArgumentException(ReferencedTabletFile.constructErrorMsg(filePath));
        }
        String fileName = parts[numParts - 1];
        String tabletDirectory = parts[numParts - 2];
        TableId tableId = TableId.of(parts[numParts - 3]);
        String tablesPath = parts[numParts - 4];
        String computedFilePath = "/tables/" + tableId.canonical() + "/" + tabletDirectory + "/" + fileName;
        String uriString = uri.toString();
        int idx = uriString.lastIndexOf(computedFilePath);
        if (idx == -1) {
            throw new IllegalArgumentException(ReferencedTabletFile.constructErrorMsg(filePath));
        }
        String volume = uriString.substring(0, idx);
        if (StringUtils.isBlank((CharSequence)fileName) || StringUtils.isBlank((CharSequence)tabletDirectory) || StringUtils.isBlank((CharSequence)tablesPath) || StringUtils.isBlank((CharSequence)volume)) {
            throw new IllegalArgumentException(ReferencedTabletFile.constructErrorMsg(filePath));
        }
        ValidationUtil.validateFileName(fileName);
        Preconditions.checkArgument((boolean)tablesPath.equals(HDFS_TABLES_DIR_NAME), (Object)("tables directory name is not " + HDFS_TABLES_DIR_NAME + ", is " + tablesPath));
        String normalizedPath = volume + computedFilePath;
        if (!normalizedPath.equals(uriString)) {
            throw new RuntimeException("Error parsing file path, " + normalizedPath + " != " + uriString);
        }
        return new FileParts(volume, tableId, tabletDirectory, fileName, normalizedPath);
    }

    public ReferencedTabletFile(Path metaPath) {
        super(Objects.requireNonNull(metaPath));
        log.trace("Parsing TabletFile from {}", (Object)metaPath);
        this.parts = ReferencedTabletFile.parsePath(metaPath);
    }

    public String getVolume() {
        return this.parts.getVolume();
    }

    public TableId getTableId() {
        return this.parts.getTableId();
    }

    public String getTabletDir() {
        return this.parts.getTabletDir();
    }

    @Override
    public String getFileName() {
        return this.parts.getFileName();
    }

    public String getNormalizedPathStr() {
        return this.parts.getNormalizedPath();
    }

    public String getMetaInsert() {
        return this.parts.getNormalizedPath();
    }

    public Text getMetaInsertText() {
        return new Text(this.getMetaInsert());
    }

    public StoredTabletFile insert() {
        return new StoredTabletFile(this.parts.getNormalizedPath());
    }

    @Override
    public int compareTo(ReferencedTabletFile o) {
        if (this.equals(o)) {
            return 0;
        }
        return this.parts.getNormalizedPath().compareTo(o.parts.getNormalizedPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferencedTabletFile) {
            ReferencedTabletFile that = (ReferencedTabletFile)obj;
            return this.parts.getNormalizedPath().equals(that.parts.getNormalizedPath());
        }
        return false;
    }

    public int hashCode() {
        return this.parts.getNormalizedPath().hashCode();
    }

    public String toString() {
        return this.parts.getNormalizedPath();
    }

    public static ReferencedTabletFile of(Path path) {
        return new ReferencedTabletFile(path);
    }

    public static class FileParts {
        private final String volume;
        private final TableId tableId;
        private final String tabletDir;
        private final String fileName;
        private final String normalizedPath;

        public FileParts(String volume, TableId tableId, String tabletDir, String fileName, String normalizedPath) {
            this.volume = volume;
            this.tableId = tableId;
            this.tabletDir = tabletDir;
            this.fileName = fileName;
            this.normalizedPath = normalizedPath;
        }

        public String getVolume() {
            return this.volume;
        }

        public TableId getTableId() {
            return this.tableId;
        }

        public String getTabletDir() {
            return this.tabletDir;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getNormalizedPath() {
            return this.normalizedPath;
        }
    }
}

