/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iteratorsImpl.system.DeletingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.VisibilityFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.IteratorConfig;
import org.apache.accumulo.core.tabletserver.thrift.TIteratorSetting;

public class SystemIteratorUtil {
    public static TIteratorSetting toTIteratorSetting(IteratorSetting is) {
        return new TIteratorSetting(is.getPriority(), is.getName(), is.getIteratorClass(), is.getOptions());
    }

    public static IteratorSetting toIteratorSetting(TIteratorSetting tis) {
        return new IteratorSetting(tis.getPriority(), tis.getName(), tis.getIteratorClass(), tis.getProperties());
    }

    public static IteratorConfig toIteratorConfig(List<IteratorSetting> iterators) {
        ArrayList<TIteratorSetting> tisList = new ArrayList<TIteratorSetting>();
        for (IteratorSetting iteratorSetting : iterators) {
            tisList.add(SystemIteratorUtil.toTIteratorSetting(iteratorSetting));
        }
        return new IteratorConfig(tisList);
    }

    public static SortedKeyValueIterator<Key, Value> setupSystemScanIterators(SortedKeyValueIterator<Key, Value> source, Set<Column> cols, Authorizations auths, byte[] defaultVisibility, AccumuloConfiguration conf) throws IOException {
        SortedKeyValueIterator<Key, Value> delIter = DeletingIterator.wrap(source, false, DeletingIterator.getBehavior(conf));
        ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator(delIter);
        SortedKeyValueIterator<Key, Value> colFilter = ColumnQualifierFilter.wrap(cfsi, cols);
        return VisibilityFilter.wrap(colFilter, auths, defaultVisibility);
    }
}

