/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iteratorsImpl.system;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public abstract class HeapIterator
implements SortedKeyValueIterator<Key, Value> {
    private PriorityQueue<SortedKeyValueIterator<Key, Value>> heap;
    private SortedKeyValueIterator<Key, Value> topIdx = null;
    private Key nextKey;

    protected HeapIterator() {
        this.heap = null;
    }

    protected HeapIterator(int maxSize) {
        this.createHeap(maxSize);
    }

    protected void createHeap(int maxSize) {
        if (this.heap != null) {
            throw new IllegalStateException("heap already exist");
        }
        this.heap = new PriorityQueue(maxSize == 0 ? 1 : maxSize, (si1, si2) -> ((Key)si1.getTopKey()).compareTo((Key)si2.getTopKey()));
    }

    @Override
    public final Key getTopKey() {
        return this.topIdx.getTopKey();
    }

    @Override
    public final Value getTopValue() {
        return this.topIdx.getTopValue();
    }

    @Override
    public final boolean hasTop() {
        return this.topIdx != null;
    }

    @Override
    public final void next() throws IOException {
        if (this.topIdx == null) {
            throw new IllegalStateException("Called next() when there is no top");
        }
        this.topIdx.next();
        if (this.topIdx.hasTop()) {
            if (this.nextKey == null) {
                return;
            }
            if (this.nextKey.compareTo(this.topIdx.getTopKey()) < 0) {
                SortedKeyValueIterator nextTopIdx = (SortedKeyValueIterator)this.heap.remove();
                this.heap.add(this.topIdx);
                this.topIdx = nextTopIdx;
                this.nextKey = this.heap.peek().getTopKey();
            }
        } else {
            if (this.nextKey == null) {
                this.topIdx = null;
                return;
            }
            this.pullReferencesFromHeap();
        }
    }

    private void pullReferencesFromHeap() {
        this.topIdx = (SortedKeyValueIterator)this.heap.remove();
        this.nextKey = this.heap.isEmpty() ? null : this.heap.peek().getTopKey();
    }

    protected final void clear() {
        this.heap.clear();
        this.topIdx = null;
        this.nextKey = null;
    }

    protected final void addSource(SortedKeyValueIterator<Key, Value> source) {
        if (source.hasTop()) {
            this.heap.add(source);
            if (this.topIdx != null) {
                this.heap.add(this.topIdx);
            }
            this.pullReferencesFromHeap();
        }
    }
}

