/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooSession;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooReaderWriter
extends ZooReader {
    private final String secret;
    private final byte[] auth;

    public ZooReaderWriter(AccumuloConfiguration conf) {
        this(conf.get(Property.INSTANCE_ZK_HOST), (int)conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), conf.get(Property.INSTANCE_SECRET));
    }

    ZooReaderWriter(String keepers, int timeoutInMillis, String secret) {
        super(keepers, timeoutInMillis);
        this.secret = Objects.requireNonNull(secret);
        this.auth = ("accumulo:" + secret).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public ZooReaderWriter asWriter(String secret) {
        if (this.secret.equals(secret)) {
            return this;
        }
        return super.asWriter(secret);
    }

    @Override
    public ZooKeeper getZooKeeper() {
        return ZooSession.getAuthenticatedSession(this.keepers, this.timeout, "digest", this.auth);
    }

    public List<ACL> getACL(String zPath) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.getACL(zPath, null));
    }

    public boolean putPersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return this.putPersistentData(zPath, data, policy, ZooUtil.PUBLIC);
    }

    public boolean putPrivatePersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return this.putPersistentData(zPath, data, policy, ZooUtil.PRIVATE);
    }

    public boolean putPersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy, List<ACL> acls) throws KeeperException, InterruptedException {
        Objects.requireNonNull(acls);
        Objects.requireNonNull(policy);
        return this.retryLoop(zk -> {
            try {
                zk.create(zPath, data, acls, CreateMode.PERSISTENT);
                return true;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    switch (policy) {
                        case SKIP: {
                            return false;
                        }
                        case OVERWRITE: {
                            zk.setData(zPath, data, -1);
                            return true;
                        }
                    }
                }
                throw e;
            }
        }, e -> e.code() == KeeperException.Code.NONODE && policy == ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    public boolean overwritePersistentData(String zPath, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> {
            try {
                zk.setData(zPath, data, expectedVersion);
                return true;
            }
            catch (KeeperException.BadVersionException ex) {
                return false;
            }
        });
    }

    public String putPersistentSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.create(zPath, data, ZooUtil.PUBLIC, CreateMode.PERSISTENT_SEQUENTIAL));
    }

    public void putEphemeralData(String zPath, byte[] data) throws KeeperException, InterruptedException {
        this.retryLoop(zk -> zk.create(zPath, data, ZooUtil.PUBLIC, CreateMode.EPHEMERAL));
    }

    public String putEphemeralSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return this.retryLoop(zk -> zk.create(zPath, data, ZooUtil.PUBLIC, CreateMode.EPHEMERAL_SEQUENTIAL));
    }

    public void recursiveCopyPersistentOverwrite(String source, String destination) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] data = this.getData(source, stat);
        if (stat.getEphemeralOwner() != 0L) {
            return;
        }
        this.putPersistentData(destination, data, ZooUtil.NodeExistsPolicy.OVERWRITE);
        if (stat.getNumChildren() > 0) {
            for (String child : this.getChildren(source)) {
                this.recursiveCopyPersistentOverwrite(source + "/" + child, destination + "/" + child);
            }
        }
    }

    public byte[] mutateExisting(String zPath, Mutator mutator) throws KeeperException, InterruptedException, AcceptableThriftTableOperationException {
        Objects.requireNonNull(mutator);
        return this.retryLoopMutator(zk -> {
            Stat stat = new Stat();
            byte[] data = zk.getData(zPath, null, stat);
            if ((data = mutator.mutate(data)) != null) {
                zk.setData(zPath, data, stat.getVersion());
            }
            return data;
        }, e -> e.code() == KeeperException.Code.BADVERSION);
    }

    public byte[] mutateOrCreate(String zPath, byte[] createValue, Mutator mutator) throws KeeperException, InterruptedException, AcceptableThriftTableOperationException {
        Objects.requireNonNull(mutator);
        return this.putPersistentData(zPath, createValue, ZooUtil.NodeExistsPolicy.SKIP) ? createValue : this.mutateExisting(zPath, mutator);
    }

    public void mkdirs(String path) throws KeeperException, InterruptedException {
        if (path.equals("")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path + "does not start with /");
        }
        if (this.exists(path)) {
            return;
        }
        String parent = path.substring(0, path.lastIndexOf("/"));
        this.mkdirs(parent);
        this.putPersistentData(path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }

    public void delete(String path) throws KeeperException, InterruptedException {
        block2: {
            try {
                this.deleteStrict(path, -1);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) break block2;
                throw e;
            }
        }
    }

    public void deleteStrict(String path, int version) throws KeeperException, InterruptedException {
        this.retryLoop(zk -> {
            zk.delete(path, version);
            return null;
        });
    }

    public void recursiveDelete(String zPath, ZooUtil.NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveDelete(this.getZooKeeper(), zPath, policy);
    }

    public static interface Mutator {
        public byte[] mutate(byte[] var1) throws AcceptableThriftTableOperationException;
    }
}

