/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;

public class DefaultConfiguration
extends AccumuloConfiguration {
    private static final Supplier<DefaultConfiguration> instance = Suppliers.memoize(DefaultConfiguration::new);
    private final Map<String, String> resolvedProps = Arrays.stream(Property.values()).filter(p -> p.getType() != PropertyType.PREFIX).collect(Collectors.toMap(Property::getKey, Property::getDefaultValue));

    private DefaultConfiguration() {
    }

    public static DefaultConfiguration getInstance() {
        return instance.get();
    }

    @Override
    public String get(Property property) {
        return this.resolvedProps.get(property.getKey());
    }

    @Override
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        this.resolvedProps.entrySet().stream().filter(p -> filter.test((String)p.getKey())).forEach(e -> props.put((String)e.getKey(), (String)e.getValue()));
    }

    @Override
    public boolean isPropertySet(Property prop) {
        return false;
    }
}

