/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocatorImpl;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.lock.ServiceLock;

public class ZookeeperLockChecker
implements TabletLocatorImpl.TabletServerLockChecker {
    private final ZooCache zc;
    private final String root;

    ZookeeperLockChecker(ClientContext context) {
        this.zc = context.getZooCache();
        this.root = context.getZooKeeperRoot() + "/tservers";
    }

    @Override
    public boolean isLockHeld(String tserver, String session) {
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path(this.root + "/" + tserver);
        return ServiceLock.getSessionId(this.zc, zLockPath) == Long.parseLong(session, 16);
    }

    @Override
    public void invalidateCache(String tserver) {
        this.zc.clear(this.root + "/" + tserver);
    }
}

