/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.AccumuloServerException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.IsolationException;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptImpl;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptReporter;
import org.apache.accumulo.core.clientImpl.ScanServerAttemptsImpl;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.TabletType;
import org.apache.accumulo.core.clientImpl.thrift.TInfo;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.InitialScan;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.ScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKeyValue;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.scan.ScanServerAttempt;
import org.apache.accumulo.core.spi.scan.ScanServerSelections;
import org.apache.accumulo.core.spi.scan.ScanServerSelector;
import org.apache.accumulo.core.tabletscan.thrift.ScanServerBusyException;
import org.apache.accumulo.core.tabletscan.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletscan.thrift.TabletScanClientService;
import org.apache.accumulo.core.tabletscan.thrift.TooManyFilesException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LazySingletons;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftScanner {
    private static final Logger log = LoggerFactory.getLogger(ThriftScanner.class);
    public static final Map<TabletType, Set<String>> serversWaitedForWrites = new EnumMap<TabletType, Set<String>>(TabletType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getBatchFromServer(ClientContext context, Range range, KeyExtent extent, String server, SortedMap<Key, Value> results, SortedSet<Column> fetchedColumns, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, int size, Authorizations authorizations, long batchTimeOut, String classLoaderContext) throws AccumuloException, AccumuloSecurityException {
        block11: {
            boolean bl;
            if (server == null) {
                throw new AccumuloException(new IOException());
            }
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TInfo tinfo = TraceUtil.traceInfo();
            TabletScanClientService.Client client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedServer, context);
            try {
                ScanState scanState = new ScanState(context, extent.tableId(), authorizations, range, fetchedColumns, size, serverSideIteratorList, serverSideIteratorOptions, false, 3L, null, batchTimeOut, classLoaderContext, null, false);
                TabletType ttype = TabletType.type(extent);
                boolean waitForWrites = !serversWaitedForWrites.get((Object)ttype).contains(server);
                InitialScan isr = client.startScan(tinfo, scanState.context.rpcCreds(), extent.toThrift(), scanState.range.toThrift(), scanState.columns.stream().map(Column::toThrift).collect(Collectors.toList()), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated, scanState.readaheadThreshold, null, scanState.batchTimeOut, classLoaderContext, scanState.executionHints, 0L);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(server);
                }
                Key.decompress(isr.result.results);
                for (TKeyValue kv : isr.result.results) {
                    results.put(new Key(kv.key), new Value(kv.value));
                }
                client.closeScan(tinfo, isr.scanID);
                bl = isr.result.more;
            }
            catch (Throwable throwable) {
                try {
                    ThriftUtil.returnClient(client, context);
                    throw throwable;
                }
                catch (TApplicationException tae) {
                    throw new AccumuloServerException(server, tae);
                }
                catch (TooManyFilesException e) {
                    log.debug("Tablet ({}) has too many files {} : {}", new Object[]{extent, server, e.getMessage()});
                    break block11;
                }
                catch (ThriftSecurityException e) {
                    log.warn("Security Violation in scan request to {}: {}", (Object)server, (Object)e.getMessage());
                    throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
                }
                catch (TException e) {
                    log.debug("Error getting transport to {}: {}", (Object)server, (Object)e.getMessage());
                }
            }
            ThriftUtil.returnClient(client, context);
            return bl;
        }
        throw new AccumuloException("getBatchFromServer: failed");
    }

    static long pause(long millis, long maxSleep, boolean runOnScanServer) throws InterruptedException {
        if (!runOnScanServer) {
            Thread.sleep(millis);
        }
        return (long)((double)Math.min(millis * 2L, maxSleep) * (0.9 + LazySingletons.RANDOM.get().nextDouble() / 5.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List<KeyValue> scan(ClientContext context, ScanState scanState, long timeOut) throws ScanTimedOutException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        loc = null;
        startTime = System.currentTimeMillis();
        lastError = null;
        error = null;
        tooManyFilesCount = 0;
        sleepMillis = 100L;
        maxSleepTime = context.getConfiguration().getTimeInMillis(Property.GENERAL_MAX_SCANNER_RETRY_PERIOD);
        results = null;
        parent = TraceUtil.startSpan(ThriftScanner.class, "scan");
        try {
            block79: {
                scope = parent.makeCurrent();
lbl12:
                // 2 sources

                try {
                    while (results == null && !scanState.finished) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new AccumuloException("Thread interrupted");
                        }
                        if ((double)(System.currentTimeMillis() - startTime) / 1000.0 > (double)timeOut) {
                            throw new ScanTimedOutException();
                        }
                        while (loc == null) {
                            currentTime = System.currentTimeMillis();
                            if ((double)(currentTime - startTime) / 1000.0 > (double)timeOut) {
                                throw new ScanTimedOutException();
                            }
                            child1 = TraceUtil.startSpan(ThriftScanner.class, "scan::locateTablet");
                            try {
                                locateSpan = child1.makeCurrent();
                                try {
                                    loc = TabletLocator.getLocator(context, scanState.tableId).locateTablet(context, scanState.startRow, scanState.skipStartRow, false);
                                    if (loc == null) {
                                        context.requireNotDeleted(scanState.tableId);
                                        context.requireNotOffline(scanState.tableId, null);
                                        error = "Failed to locate tablet for table : " + scanState.tableId + " row : " + scanState.startRow;
                                        if (!error.equals(lastError)) {
                                            ThriftScanner.log.debug("{}", (Object)error);
                                        } else if (ThriftScanner.log.isTraceEnabled()) {
                                            ThriftScanner.log.trace("{}", (Object)error);
                                        }
                                        lastError = error;
                                        sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime, scanState.runOnScanServer);
                                        continue;
                                    }
                                    dataRange = loc.getExtent().toDataRange();
                                    if (scanState.range.getStartKey() != null && dataRange.afterEndKey(scanState.range.getStartKey())) {
                                        scanState.startRow = loc.getExtent().endRow();
                                        scanState.skipStartRow = true;
                                        loc = null;
                                        continue;
                                    }
                                    if (scanState.range.getEndKey() == null || !dataRange.beforeStartKey(scanState.range.getEndKey())) continue;
                                    throw new IllegalStateException("Unexpected tablet, extent : " + loc.getExtent() + "  range : " + scanState.range + " startRow : " + scanState.startRow);
                                }
                                finally {
                                    if (locateSpan == null) continue;
                                    locateSpan.close();
                                }
                            }
                            catch (AccumuloServerException e) {
                                TraceUtil.setException(child1, e, true);
                                ThriftScanner.log.debug("Scan failed, server side exception : {}", (Object)e.getMessage());
                                throw e;
                            }
                            catch (AccumuloException e) {
                                error = "exception from tablet loc " + e.getMessage();
                                if (!error.equals(lastError)) {
                                    ThriftScanner.log.debug("{}", (Object)error);
                                } else if (ThriftScanner.log.isTraceEnabled()) {
                                    ThriftScanner.log.trace("{}", (Object)error);
                                }
                                TraceUtil.setException(child1, e, false);
                                lastError = error;
                                sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime, scanState.runOnScanServer);
                            }
                            finally {
                                child1.end();
                            }
                        }
                        child2 = TraceUtil.startSpan(ThriftScanner.class, "scan::location", Map.of("tserver", loc.getTserverLocation()));
                        try {
                            scanLocation = child2.makeCurrent();
                            try {
                                results = ThriftScanner.scan(loc, scanState, context);
                            }
                            finally {
                                if (scanLocation == null) ** GOTO lbl12
                                scanLocation.close();
                            }
                        }
                        catch (AccumuloSecurityException e) {
                            context.clearTableListCache();
                            context.requireNotDeleted(scanState.tableId);
                            e.setTableInfo(context.getPrintableTableInfoFromId(scanState.tableId));
                            TraceUtil.setException(child2, e, true);
                            throw e;
                        }
                        catch (TApplicationException tae) {
                            TraceUtil.setException(child2, tae, true);
                            throw new AccumuloServerException(scanState.getErrorLocation().getTserverLocation(), tae);
                        }
                        catch (TSampleNotPresentException tsnpe) {
                            message = "Table " + context.getPrintableTableInfoFromId(scanState.tableId) + " does not have sampling configured or built";
                            TraceUtil.setException(child2, (Throwable)tsnpe, true);
                            throw new SampleNotPresentException(message, (Exception)tsnpe);
                        }
                        catch (NotServingTabletException e) {
                            error = "Scan failed, not serving tablet " + scanState.getErrorLocation();
                            if (!error.equals(lastError)) {
                                ThriftScanner.log.debug("{}", (Object)error);
                            } else if (ThriftScanner.log.isTraceEnabled()) {
                                ThriftScanner.log.trace("{}", (Object)error);
                            }
                            lastError = error;
                            TabletLocator.getLocator(context, scanState.tableId).invalidateCache(loc.getExtent());
                            loc = null;
                            scanState.scanID = null;
                            if (scanState.isolated) {
                                TraceUtil.setException(child2, (Throwable)e, true);
                                throw new IsolationException();
                            }
                            TraceUtil.setException(child2, (Throwable)e, false);
                            sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime, scanState.runOnScanServer);
                        }
                        catch (ScanServerBusyException e) {
                            error = "Scan failed, scan server was busy " + scanState.getErrorLocation();
                            if (!error.equals(lastError)) {
                                ThriftScanner.log.debug("{}", (Object)error);
                            } else if (ThriftScanner.log.isTraceEnabled()) {
                                ThriftScanner.log.trace("{}", (Object)error);
                            }
                            lastError = error;
                            if (scanState.isolated) {
                                TraceUtil.setException(child2, (Throwable)e, true);
                                throw new IsolationException();
                            }
                            TraceUtil.setException(child2, (Throwable)e, false);
                            scanState.scanID = null;
                        }
                        catch (NoSuchScanIDException e) {
                            error = "Scan failed, no such scan id " + scanState.scanID + " " + scanState.getErrorLocation();
                            if (!error.equals(lastError)) {
                                ThriftScanner.log.debug("{}", (Object)error);
                            } else if (ThriftScanner.log.isTraceEnabled()) {
                                ThriftScanner.log.trace("{}", (Object)error);
                            }
                            lastError = error;
                            if (scanState.isolated) {
                                TraceUtil.setException(child2, (Throwable)e, true);
                                throw new IsolationException();
                            }
                            TraceUtil.setException(child2, (Throwable)e, false);
                            scanState.scanID = null;
                        }
                        catch (TooManyFilesException e) {
                            error = "Tablet has too many files " + scanState.getErrorLocation() + " retrying...";
                            if (error.equals(lastError)) {
                                if (++tooManyFilesCount == 300) {
                                    ThriftScanner.log.warn("{}", (Object)error);
                                } else if (ThriftScanner.log.isTraceEnabled()) {
                                    ThriftScanner.log.trace("{}", (Object)error);
                                }
                            } else {
                                ThriftScanner.log.debug("{}", (Object)error);
                                tooManyFilesCount = 0;
                            }
                            lastError = error;
                            scanState.scanID = null;
                            if (scanState.isolated) {
                                TraceUtil.setException(child2, (Throwable)e, true);
                                throw new IsolationException();
                            }
                            TraceUtil.setException(child2, (Throwable)e, false);
                            sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime, scanState.runOnScanServer);
                        }
                        catch (TException e) {
                            TabletLocator.getLocator(context, scanState.tableId).invalidateCache(context, loc.getTserverLocation());
                            error = "Scan failed, thrift error " + e.getClass().getName() + "  " + e.getMessage() + " " + scanState.getErrorLocation();
                            if (!error.equals(lastError)) {
                                ThriftScanner.log.debug("{}", (Object)error);
                            } else if (ThriftScanner.log.isTraceEnabled()) {
                                ThriftScanner.log.trace("{}", (Object)error);
                            }
                            lastError = error;
                            loc = null;
                            scanState.scanID = null;
                            if (scanState.isolated) {
                                TraceUtil.setException(child2, e, true);
                                throw new IsolationException();
                            }
                            TraceUtil.setException(child2, e, false);
                            sleepMillis = ThriftScanner.pause(sleepMillis, maxSleepTime, scanState.runOnScanServer);
                        }
                        finally {
                            child2.end();
                        }
                    }
                    if (results != null && results.isEmpty() && scanState.finished) {
                        results = null;
                    }
                    var17_14 = results;
                    if (scope == null) break block79;
                }
                catch (Throwable var17_16) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable var18_26) {
                                var17_16.addSuppressed(var18_26);
                            }
                        }
                        throw var17_16;
                    }
                    catch (InterruptedException ex) {
                        TraceUtil.setException(parent, ex, true);
                        throw new AccumuloException(ex);
                    }
                }
                scope.close();
            }
            return var17_14;
        }
        finally {
            parent.end();
        }
    }

    private static List<KeyValue> scan(TabletLocator.TabletLocation loc, final ScanState scanState, ClientContext context) throws AccumuloSecurityException, NotServingTabletException, TException, NoSuchScanIDException, TooManyFilesException, TSampleNotPresentException {
        if (scanState.finished) {
            return null;
        }
        if (scanState.runOnScanServer) {
            TabletLocator.TabletLocation newLoc;
            final TabletIdImpl tabletId = new TabletIdImpl(loc.getExtent());
            if (scanState.scanID != null && scanState.prevLoc != null && scanState.prevLoc.getTserverSession().equals("scan_server") && scanState.prevLoc.getExtent().equals(loc.getExtent())) {
                newLoc = scanState.prevLoc;
                log.trace("For tablet {} continuing scan on scan server {} without consulting scan server selector, using busyTimeout {}", new Object[]{loc.getExtent(), newLoc.getTserverLocation(), scanState.busyTimeout});
            } else {
                final Map<TabletId, Collection<ScanServerAttemptImpl>> attempts = scanState.scanAttempts.snapshot();
                ScanServerSelector.SelectorParameters params = new ScanServerSelector.SelectorParameters(){

                    public List<TabletId> getTablets() {
                        return List.of(tabletId);
                    }

                    @Override
                    public Collection<? extends ScanServerAttempt> getAttempts(TabletId tabletId2) {
                        return attempts.getOrDefault(tabletId2, Set.of());
                    }

                    @Override
                    public Map<String, String> getHints() {
                        if (scanState.executionHints == null) {
                            return Map.of();
                        }
                        return scanState.executionHints;
                    }
                };
                ScanServerSelections actions = context.getScanServerSelector().selectServers(params);
                Duration delay = null;
                String scanServer = actions.getScanServer(tabletId);
                if (scanServer != null) {
                    newLoc = new TabletLocator.TabletLocation(loc.getExtent(), scanServer, "scan_server");
                    delay = actions.getDelay();
                    scanState.busyTimeout = actions.getBusyTimeout();
                    log.trace("For tablet {} scan server selector chose scan_server:{} delay:{} busyTimeout:{}", new Object[]{loc.getExtent(), scanServer, delay, scanState.busyTimeout});
                } else {
                    newLoc = loc;
                    delay = actions.getDelay();
                    scanState.busyTimeout = Duration.ZERO;
                    log.trace("For tablet {} scan server selector chose tablet_server", (Object)loc.getExtent());
                }
                if (!delay.isZero()) {
                    try {
                        Thread.sleep(delay.toMillis());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
            ScanServerAttemptReporter reporter = scanState.scanAttempts.createReporter(newLoc.getTserverLocation(), tabletId);
            try {
                return ThriftScanner.scanRpc(newLoc, scanState, context, scanState.busyTimeout.toMillis());
            }
            catch (ScanServerBusyException ssbe) {
                reporter.report(ScanServerAttempt.Result.BUSY);
                throw ssbe;
            }
            catch (Exception e) {
                reporter.report(ScanServerAttempt.Result.ERROR);
                throw e;
            }
        }
        return ThriftScanner.scanRpc(loc, scanState, context, 0L);
    }

    private static List<KeyValue> scanRpc(TabletLocator.TabletLocation loc, ScanState scanState, ClientContext context, long busyTimeout) throws AccumuloSecurityException, NotServingTabletException, TException, NoSuchScanIDException, TooManyFilesException, TSampleNotPresentException, ScanServerBusyException {
        OpTimer timer = null;
        TInfo tinfo = TraceUtil.traceInfo();
        HostAndPort parsedLocation = HostAndPort.fromString((String)loc.getTserverLocation());
        TabletScanClientService.Client client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedLocation, context);
        String old = Thread.currentThread().getName();
        try {
            ScanResult sr;
            String msg;
            if (scanState.prevLoc != null && !scanState.prevLoc.equals(loc)) {
                scanState.scanID = null;
            }
            scanState.prevLoc = loc;
            if (scanState.scanID == null) {
                TabletType ttype;
                Thread.currentThread().setName("Starting scan tserver=" + loc.getTserverLocation() + " tableId=" + loc.getExtent().tableId());
                if (log.isTraceEnabled()) {
                    msg = "Starting scan tserver=" + loc.getTserverLocation() + " tablet=" + loc.getExtent() + " range=" + scanState.range + " ssil=" + scanState.serverSideIteratorList + " ssio=" + scanState.serverSideIteratorOptions + " context=" + scanState.classLoaderContext;
                    log.trace("tid={} {}", (Object)Thread.currentThread().getId(), (Object)msg);
                    timer = new OpTimer().start();
                }
                boolean waitForWrites = !serversWaitedForWrites.get((Object)(ttype = TabletType.type(loc.getExtent()))).contains(loc.getTserverLocation());
                InitialScan is = client.startScan(tinfo, scanState.context.rpcCreds(), loc.getExtent().toThrift(), scanState.range.toThrift(), scanState.columns.stream().map(Column::toThrift).collect(Collectors.toList()), scanState.size, scanState.serverSideIteratorList, scanState.serverSideIteratorOptions, scanState.authorizations.getAuthorizationsBB(), waitForWrites, scanState.isolated, scanState.readaheadThreshold, SamplerConfigurationImpl.toThrift(scanState.samplerConfig), scanState.batchTimeOut, scanState.classLoaderContext, scanState.executionHints, busyTimeout);
                if (waitForWrites) {
                    serversWaitedForWrites.get((Object)ttype).add(loc.getTserverLocation());
                }
                sr = is.result;
                if (sr.more) {
                    scanState.scanID = is.scanID;
                } else {
                    client.closeScan(tinfo, is.scanID);
                }
            } else {
                msg = "Continuing scan tserver=" + loc.getTserverLocation() + " scanid=" + scanState.scanID;
                Thread.currentThread().setName(msg);
                if (log.isTraceEnabled()) {
                    log.trace("tid={} {}", (Object)Thread.currentThread().getId(), (Object)msg);
                    timer = new OpTimer().start();
                }
                sr = client.continueScan(tinfo, scanState.scanID, busyTimeout);
                if (!sr.more) {
                    client.closeScan(tinfo, scanState.scanID);
                    scanState.scanID = null;
                }
            }
            if (sr.more) {
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Finished scan in {} #results={} scanid={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size(), scanState.scanID});
                }
            } else if (loc.getExtent().endRow() == null) {
                scanState.finished = true;
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Completely finished scan in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                }
            } else if (scanState.range.getEndKey() == null || !scanState.range.afterEndKey(new Key(loc.getExtent().endRow()).followingKey(PartialKey.ROW))) {
                scanState.startRow = loc.getExtent().endRow();
                scanState.skipStartRow = true;
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Finished scanning tablet in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                }
            } else {
                scanState.finished = true;
                if (timer != null) {
                    timer.stop();
                    log.trace("tid={} Completely finished in {} #results={}", new Object[]{Thread.currentThread().getId(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS)), sr.results.size()});
                }
            }
            Key.decompress(sr.results);
            if (!sr.results.isEmpty() && !scanState.finished) {
                scanState.range = new Range(new Key(sr.results.get((int)(sr.results.size() - 1)).key), false, scanState.range.getEndKey(), scanState.range.isEndKeyInclusive());
            }
            ArrayList<KeyValue> results = new ArrayList<KeyValue>(sr.results.size());
            for (TKeyValue tkv : sr.results) {
                results.add(new KeyValue(new Key(tkv.key), tkv.value));
            }
            ArrayList<KeyValue> arrayList = results;
            return arrayList;
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        finally {
            ThriftUtil.returnClient(client, context);
            Thread.currentThread().setName(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void close(ScanState scanState) {
        if (!scanState.finished && scanState.scanID != null && scanState.prevLoc != null) {
            TInfo tinfo = TraceUtil.traceInfo();
            log.debug("Closing active scan {} {}", (Object)scanState.prevLoc, (Object)scanState.scanID);
            HostAndPort parsedLocation = HostAndPort.fromString((String)scanState.prevLoc.getTserverLocation());
            TabletScanClientService.Client client = null;
            try {
                client = ThriftUtil.getClient(ThriftClientTypes.TABLET_SCAN, parsedLocation, scanState.context);
                client.closeScan(tinfo, scanState.scanID);
            }
            catch (TException e) {
                log.debug("Failed to close active scan " + scanState.prevLoc + " " + scanState.scanID, (Throwable)e);
            }
            finally {
                if (client != null) {
                    ThriftUtil.returnClient(client, scanState.context);
                }
            }
        }
    }

    static {
        for (TabletType ttype : TabletType.values()) {
            serversWaitedForWrites.put(ttype, Collections.synchronizedSet(new HashSet()));
        }
    }

    public static class ScanTimedOutException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }

    public static class ScanState {
        boolean isolated;
        TableId tableId;
        Text startRow;
        boolean skipStartRow;
        long readaheadThreshold;
        long batchTimeOut;
        boolean runOnScanServer;
        Range range;
        int size;
        ClientContext context;
        Authorizations authorizations;
        List<Column> columns;
        TabletLocator.TabletLocation prevLoc;
        Long scanID;
        String classLoaderContext;
        boolean finished = false;
        List<IterInfo> serverSideIteratorList;
        Map<String, Map<String, String>> serverSideIteratorOptions;
        SamplerConfiguration samplerConfig;
        Map<String, String> executionHints;
        ScanServerAttemptsImpl scanAttempts;
        Duration busyTimeout;

        TabletLocator.TabletLocation getErrorLocation() {
            return this.prevLoc;
        }

        public ScanState(ClientContext context, TableId tableId, Authorizations authorizations, Range range, SortedSet<Column> fetchedColumns, int size, List<IterInfo> serverSideIteratorList, Map<String, Map<String, String>> serverSideIteratorOptions, boolean isolated, long readaheadThreshold, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext, Map<String, String> executionHints, boolean useScanServer) {
            this.context = context;
            this.authorizations = authorizations;
            this.classLoaderContext = classLoaderContext;
            this.columns = new ArrayList<Column>(fetchedColumns.size());
            for (Column column : fetchedColumns) {
                this.columns.add(column);
            }
            this.tableId = tableId;
            this.range = range;
            Key startKey = range.getStartKey();
            if (startKey == null) {
                startKey = new Key();
            }
            this.startRow = startKey.getRow();
            this.skipStartRow = false;
            this.size = size;
            this.serverSideIteratorList = serverSideIteratorList;
            this.serverSideIteratorOptions = serverSideIteratorOptions;
            this.isolated = isolated;
            this.readaheadThreshold = readaheadThreshold;
            this.samplerConfig = samplerConfig;
            this.batchTimeOut = batchTimeOut;
            this.executionHints = executionHints == null || executionHints.isEmpty() ? null : executionHints;
            this.runOnScanServer = useScanServer;
            if (useScanServer) {
                this.scanAttempts = new ScanServerAttemptsImpl();
            }
        }
    }
}

