/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.HadoopCredentialProvider;
import org.apache.hadoop.conf.Configuration;

public class CredentialProviderToken
extends PasswordToken {
    public static final String NAME_PROPERTY = "name";
    public static final String CREDENTIAL_PROVIDERS_PROPERTY = "credentialProviders";
    private String name;
    private String credentialProviders;

    public CredentialProviderToken() {
    }

    public CredentialProviderToken(String name, String credentialProviders) throws IOException {
        Objects.requireNonNull(name);
        Objects.requireNonNull(credentialProviders);
        this.setWithCredentialProviders(name, credentialProviders);
    }

    protected void setWithCredentialProviders(String name, String credentialProviders) throws IOException {
        this.name = name;
        this.credentialProviders = credentialProviders;
        Configuration conf = new Configuration();
        HadoopCredentialProvider.setPath(conf, credentialProviders);
        char[] password = HadoopCredentialProvider.getValue(conf, name);
        if (password == null) {
            throw new IOException("No password could be extracted from CredentialProvider(s) with " + name);
        }
        this.setPassword(CharBuffer.wrap(password));
    }

    public String getName() {
        return this.name;
    }

    public String getCredentialProviders() {
        return this.credentialProviders;
    }

    @Override
    public void init(AuthenticationToken.Properties properties) {
        char[] nameCharArray = properties.get(NAME_PROPERTY);
        char[] credentialProvidersCharArray = properties.get(CREDENTIAL_PROVIDERS_PROPERTY);
        if (nameCharArray != null && credentialProvidersCharArray != null) {
            try {
                this.setWithCredentialProviders(new String(nameCharArray), new String(credentialProvidersCharArray));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not extract password from CredentialProvider", e);
            }
            return;
        }
        throw new IllegalArgumentException("Expected name and credentialProviders properties.");
    }

    @Override
    public Set<AuthenticationToken.TokenProperty> getProperties() {
        LinkedHashSet<AuthenticationToken.TokenProperty> properties = new LinkedHashSet<AuthenticationToken.TokenProperty>();
        properties.add(new AuthenticationToken.TokenProperty(NAME_PROPERTY, "Alias to extract from CredentialProvider", false));
        properties.add(new AuthenticationToken.TokenProperty(CREDENTIAL_PROVIDERS_PROPERTY, "Comma separated list of URLs defining CredentialProvider(s)", false));
        return properties;
    }

    @Override
    public CredentialProviderToken clone() {
        CredentialProviderToken clone = (CredentialProviderToken)super.clone();
        clone.setPassword(this.getPassword());
        return clone;
    }
}

