/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.hadoop.io.Text;

public class CompactionConfig {
    private Text start = null;
    private Text end = null;
    private boolean flush = true;
    private boolean wait = true;
    private List<IteratorSetting> iterators = Collections.emptyList();
    private Map<String, String> hints = Map.of();
    private PluginConfig selectorConfig = UserCompactionUtils.DEFAULT_SELECTOR;
    private PluginConfig configurerConfig = UserCompactionUtils.DEFAULT_CONFIGURER;

    public CompactionConfig setStartRow(Text start) {
        this.start = start;
        return this;
    }

    public Text getStartRow() {
        return this.start;
    }

    public CompactionConfig setEndRow(Text end) {
        this.end = end;
        return this;
    }

    public Text getEndRow() {
        return this.end;
    }

    public CompactionConfig setFlush(boolean flush2) {
        this.flush = flush2;
        return this;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public CompactionConfig setWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    public boolean getWait() {
        return this.wait;
    }

    public CompactionConfig setIterators(List<IteratorSetting> iterators) {
        this.iterators = List.copyOf(iterators);
        return this;
    }

    public List<IteratorSetting> getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public CompactionConfig setSelector(PluginConfig selectorConfig) {
        Preconditions.checkArgument((!selectorConfig.getClassName().isBlank() ? 1 : 0) != 0);
        this.selectorConfig = Objects.requireNonNull(selectorConfig);
        return this;
    }

    public PluginConfig getSelector() {
        return this.selectorConfig;
    }

    public CompactionConfig setExecutionHints(Map<String, String> hints) {
        this.hints = Map.copyOf(hints);
        return this;
    }

    public Map<String, String> getExecutionHints() {
        return this.hints;
    }

    public CompactionConfig setConfigurer(PluginConfig configurerConfig) {
        this.configurerConfig = configurerConfig;
        return this;
    }

    public PluginConfig getConfigurer() {
        return this.configurerConfig;
    }

    private String append(StringBuilder sb, String prefix, BooleanSupplier test, String name, Object val) {
        if (test.getAsBoolean()) {
            sb.append(prefix);
            sb.append(name);
            sb.append("=");
            sb.append(val);
            return ", ";
        }
        return prefix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        String prefix = this.append(sb, "", () -> this.start != null, "start", this.start);
        prefix = this.append(sb, prefix, () -> this.end != null, "end", this.end);
        prefix = this.append(sb, prefix, () -> !this.flush, "flush", this.flush);
        prefix = this.append(sb, prefix, () -> !this.wait, "wait", this.wait);
        prefix = this.append(sb, prefix, () -> !this.iterators.isEmpty(), "iterators", this.iterators);
        prefix = this.append(sb, prefix, () -> !UserCompactionUtils.isDefault(this.selectorConfig), "selector", this.selectorConfig);
        prefix = this.append(sb, prefix, () -> !UserCompactionUtils.isDefault(this.configurerConfig), "configurer", this.configurerConfig);
        prefix = this.append(sb, prefix, () -> !this.hints.isEmpty(), "hints", this.hints);
        sb.append("]");
        return sb.toString();
    }
}

