/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.FileReplicator;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class UniqueFileReplicator
implements VfsComponent,
FileReplicator {
    private static final char[] TMP_RESERVED_CHARS = new char[]{'?', '/', '\\', ' ', '&', '\"', '\'', '*', '#', ';', ':', '<', '>', '|'};
    private static final Logger log = LoggerFactory.getLogger(UniqueFileReplicator.class);
    private File tempDir;
    private VfsComponentContext context;
    private List<File> tmpFiles = Collections.synchronizedList(new ArrayList());

    public UniqueFileReplicator(File tempDir) {
        this.tempDir = tempDir;
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            log.warn("Unexpected error creating directory {}", (Object)tempDir);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="input files are specified by admin, not unchecked user input")
    public File replicateFile(FileObject srcFile, FileSelector selector) throws FileSystemException {
        String baseName = srcFile.getName().getBaseName();
        try {
            if (!this.tempDir.exists()) {
                throw new IOException("Directory no longer exists: " + this.tempDir.getAbsolutePath());
            }
            String safeBasename = UriParser.encode((String)baseName, (char[])TMP_RESERVED_CHARS).replace('%', '_');
            File file = null;
            try {
                file = File.createTempFile("vfsr_", "_" + safeBasename, this.tempDir);
            }
            catch (IOException ioe) {
                throw new IOException("Error creating temp file in directory: " + String.valueOf(this.tempDir), ioe);
            }
            file.deleteOnExit();
            FileObject destFile = this.context.toFileObject(file);
            destFile.copyFrom(srcFile, selector);
            return file;
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public void setLogger(Log logger) {
    }

    public void setContext(VfsComponentContext context) {
        this.context = context;
    }

    public void init() throws FileSystemException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<File> list = this.tmpFiles;
        synchronized (list) {
            for (File tmpFile : this.tmpFiles) {
                if (tmpFile.delete()) continue;
                log.warn("File does not exist: {}", (Object)tmpFile);
            }
        }
        if (this.tempDir.exists()) {
            int numChildren;
            String[] list2 = this.tempDir.list();
            int n = numChildren = list2 == null ? 0 : list2.length;
            if (numChildren == 0 && !this.tempDir.delete()) {
                log.warn("Cannot delete empty directory: {}", (Object)this.tempDir);
            }
        }
    }
}

