/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class GroupBalancer
implements TabletBalancer {
    protected BalancerEnvironment environment;
    private final TableId tableId;
    protected final Map<String, Long> lastRunTimes = new HashMap<String, Long>();

    @Override
    public void init(BalancerEnvironment balancerEnvironment) {
        this.environment = balancerEnvironment;
    }

    protected abstract Function<TabletId, String> getPartitioner();

    public GroupBalancer(TableId tableId) {
        this.tableId = tableId;
    }

    protected Map<TabletId, TabletServerId> getLocationProvider() {
        return this.environment.listTabletLocations(this.tableId);
    }

    protected long getWaitTime() {
        return 60000L;
    }

    protected int getMaxMigrations() {
        return 1000;
    }

    protected boolean shouldBalance(SortedMap<TabletServerId, TServerStatus> current, Set<TabletId> migrations) {
        if (current.size() < 2) {
            return false;
        }
        return migrations.stream().noneMatch(t -> t.getTable().equals(this.tableId));
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        if (params.currentStatus().isEmpty()) {
            return;
        }
        Function<TabletId, String> partitioner = this.getPartitioner();
        ArrayList<ComparablePair<String, TabletId>> tabletsByGroup = new ArrayList<ComparablePair<String, TabletId>>();
        for (Map.Entry<TabletId, TabletServerId> entry : params.unassignedTablets().entrySet()) {
            TabletServerId tabletServerId = entry.getValue();
            if (tabletServerId != null) {
                TabletServerId tserver;
                String fakeSessionID = " ";
                TabletServerIdImpl simple = new TabletServerIdImpl(tabletServerId.getHost(), tabletServerId.getPort(), fakeSessionID);
                Iterator<TabletServerId> find = params.currentStatus().tailMap(simple).keySet().iterator();
                if (find.hasNext() && (tserver = find.next()).getHost().equals(tabletServerId.getHost())) {
                    params.addAssignment(entry.getKey(), tserver);
                    continue;
                }
            }
            tabletsByGroup.add(new ComparablePair<String, TabletId>(partitioner.apply(entry.getKey()), entry.getKey()));
        }
        Collections.sort(tabletsByGroup);
        Iterator tserverIter = Iterators.cycle(params.currentStatus().keySet());
        for (ComparablePair comparablePair : tabletsByGroup) {
            TabletId tabletId = (TabletId)comparablePair.getSecond();
            params.addAssignment(tabletId, (TabletServerId)tserverIter.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        void var6_11;
        if (!this.shouldBalance(params.currentStatus(), params.currentMigrations())) {
            return 5000L;
        }
        if (System.currentTimeMillis() - this.lastRunTimes.getOrDefault(params.partitionName(), 0L) < this.getWaitTime()) {
            return 5000L;
        }
        MapCounter<Object> groupCounts = new MapCounter<Object>();
        Map<TabletServerId, TserverGroupInfo> tservers = new HashMap<TabletServerId, TserverGroupInfo>();
        for (TabletServerId tabletServerId : params.currentStatus().keySet()) {
            tservers.put(tabletServerId, new TserverGroupInfo(tabletServerId));
        }
        Function<TabletId, String> partitioner = this.getPartitioner();
        for (Map.Entry<TabletId, TabletServerId> entry : this.getLocationProvider().entrySet()) {
            String group = partitioner.apply(entry.getKey());
            TabletServerId loc = entry.getValue();
            if (loc == null || !tservers.containsKey(loc)) {
                return 5000L;
            }
            groupCounts.increment(group, 1L);
            TserverGroupInfo tgi = (TserverGroupInfo)tservers.get(loc);
            tgi.addGroup(group);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        boolean bl = false;
        for (String group : groupCounts.keySet()) {
            int groupCount = groupCounts.getInt(group);
            var6_11 += groupCount % params.currentStatus().size();
            hashMap.put(group, groupCount / params.currentStatus().size());
        }
        void expectedExtra = var6_11 / params.currentStatus().size();
        void maxExtraGroups = expectedExtra + true;
        Map<String, Integer> map = Collections.unmodifiableMap(hashMap);
        tservers = Collections.unmodifiableMap(tservers);
        for (TserverGroupInfo tgi : tservers.values()) {
            tgi.finishedAdding(map);
        }
        Moves moves = new Moves();
        this.balanceExpected(tservers, moves);
        if (moves.size() < this.getMaxMigrations()) {
            boolean cont;
            this.balanceExtraExpected(tservers, (int)expectedExtra, moves);
            if (moves.size() < this.getMaxMigrations() && (cont = this.balanceExtraMultiple(tservers, (int)maxExtraGroups, moves)) && moves.size() < this.getMaxMigrations()) {
                this.balanceExtraExtra(tservers, (int)maxExtraGroups, moves);
            }
        }
        this.populateMigrations(tservers.keySet(), params.migrationsOut(), moves);
        this.lastRunTimes.put(params.partitionName(), System.currentTimeMillis());
        return 5000L;
    }

    private void balanceExtraExtra(Map<TabletServerId, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves) {
        HashBasedTable surplusExtra = HashBasedTable.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            if (extras.size() <= maxExtraGroups) continue;
            for (String group : extras.keySet()) {
                surplusExtra.put((Object)group, (Object)tgi.getTabletServerId(), (Object)tgi);
            }
        }
        ArrayList<Pair<String, TabletServerId>> serversGroupsToRemove = new ArrayList<Pair<String, TabletServerId>>();
        HashSet<TabletServerId> serversToRemove = new HashSet<TabletServerId>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            if (surplusExtra.isEmpty()) break;
            Map<String, Integer> extras = destTgi.getExtras();
            if (extras.size() >= maxExtraGroups) continue;
            serversToRemove.clear();
            serversGroupsToRemove.clear();
            for (String string : surplusExtra.rowKeySet()) {
                if (extras.containsKey(string)) continue;
                TserverGroupInfo srcTgi = (TserverGroupInfo)surplusExtra.row((Object)string).values().iterator().next();
                moves.move(string, 1, srcTgi, destTgi);
                if (srcTgi.getExtras().size() <= maxExtraGroups) {
                    serversToRemove.add(srcTgi.getTabletServerId());
                } else {
                    serversGroupsToRemove.add(new Pair<String, TabletServerId>(string, srcTgi.getTabletServerId()));
                }
                if (destTgi.getExtras().size() < maxExtraGroups && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            if (!serversToRemove.isEmpty()) {
                surplusExtra.columnKeySet().removeAll(serversToRemove);
            }
            for (Pair pair : serversGroupsToRemove) {
                surplusExtra.remove(pair.getFirst(), pair.getSecond());
            }
            if (moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private boolean balanceExtraMultiple(Map<TabletServerId, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves) {
        HashMultimap extraMultiple = HashMultimap.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            for (Map.Entry<String, Integer> entry : extras.entrySet()) {
                if (entry.getValue() <= 1) continue;
                extraMultiple.put((Object)entry.getKey(), (Object)tgi);
            }
        }
        this.balanceExtraMultiple(tservers, maxExtraGroups, moves, (Multimap<String, TserverGroupInfo>)extraMultiple, false);
        if (moves.size() < this.getMaxMigrations() && !extraMultiple.isEmpty()) {
            this.balanceExtraMultiple(tservers, maxExtraGroups, moves, (Multimap<String, TserverGroupInfo>)extraMultiple, true);
            return false;
        }
        return true;
    }

    private void balanceExtraMultiple(Map<TabletServerId, TserverGroupInfo> tservers, int maxExtraGroups, Moves moves, Multimap<String, TserverGroupInfo> extraMultiple, boolean alwaysAdd) {
        ArrayList<Pair<String, TserverGroupInfo>> serversToRemove = new ArrayList<Pair<String, TserverGroupInfo>>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            Map<String, Integer> extras = destTgi.getExtras();
            if (!alwaysAdd && extras.size() >= maxExtraGroups) continue;
            serversToRemove.clear();
            for (String string : extraMultiple.keySet()) {
                if (extras.containsKey(string)) continue;
                Collection sources = extraMultiple.get((Object)string);
                Iterator iter = sources.iterator();
                TserverGroupInfo srcTgi = (TserverGroupInfo)iter.next();
                int num = srcTgi.getExtras().get(string);
                moves.move(string, 1, srcTgi, destTgi);
                if (num == 2) {
                    serversToRemove.add(new Pair<String, TserverGroupInfo>(string, srcTgi));
                }
                if (destTgi.getExtras().size() < maxExtraGroups && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            for (Pair pair : serversToRemove) {
                extraMultiple.remove(pair.getFirst(), pair.getSecond());
            }
            if (!extraMultiple.isEmpty() && moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private void balanceExtraExpected(Map<TabletServerId, TserverGroupInfo> tservers, int expectedExtra, Moves moves) {
        HashBasedTable extraSurplus = HashBasedTable.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            Map<String, Integer> extras = tgi.getExtras();
            if (extras.size() <= expectedExtra) continue;
            for (String group : extras.keySet()) {
                extraSurplus.put((Object)group, (Object)tgi.getTabletServerId(), (Object)tgi);
            }
        }
        HashSet<TabletServerId> emptyServers = new HashSet<TabletServerId>();
        ArrayList<Pair<String, TabletServerId>> emptyServerGroups = new ArrayList<Pair<String, TabletServerId>>();
        for (TserverGroupInfo destTgi : tservers.values()) {
            if (extraSurplus.isEmpty()) break;
            Map<String, Integer> extras = destTgi.getExtras();
            if (extras.size() >= expectedExtra) continue;
            emptyServers.clear();
            emptyServerGroups.clear();
            block3: for (String string : extraSurplus.rowKeySet()) {
                if (extras.containsKey(string)) continue;
                Iterator iter = extraSurplus.row((Object)string).values().iterator();
                TserverGroupInfo srcTgi = (TserverGroupInfo)iter.next();
                while (srcTgi.getExtras().size() <= expectedExtra) {
                    if (!iter.hasNext()) continue block3;
                    srcTgi = (TserverGroupInfo)iter.next();
                }
                moves.move(string, 1, srcTgi, destTgi);
                if (srcTgi.getExtras().size() <= expectedExtra) {
                    emptyServers.add(srcTgi.getTabletServerId());
                } else if (srcTgi.getExtras().get(string) == null) {
                    emptyServerGroups.add(new Pair<String, TabletServerId>(string, srcTgi.getTabletServerId()));
                }
                if (destTgi.getExtras().size() < expectedExtra && moves.size() < this.getMaxMigrations()) continue;
                break;
            }
            if (!emptyServers.isEmpty()) {
                extraSurplus.columnKeySet().removeAll(emptyServers);
            }
            for (Pair pair : emptyServerGroups) {
                extraSurplus.remove(pair.getFirst(), pair.getSecond());
            }
            if (moves.size() < this.getMaxMigrations()) continue;
            break;
        }
    }

    private void balanceExpected(Map<TabletServerId, TserverGroupInfo> tservers, Moves moves) {
        HashMultimap groupDefecits = HashMultimap.create();
        HashMultimap groupSurplus = HashMultimap.create();
        for (TserverGroupInfo tgi : tservers.values()) {
            for (String group : tgi.getExpectedDeficits().keySet()) {
                groupDefecits.put((Object)group, (Object)tgi);
            }
            for (String group : tgi.getExtras().keySet()) {
                groupSurplus.put((Object)group, (Object)tgi);
            }
        }
        for (String group : groupDefecits.keySet()) {
            Collection defecitServers = groupDefecits.get((Object)group);
            for (TserverGroupInfo defecitTsi : defecitServers) {
                int transfer;
                Iterator surplusIter = groupSurplus.get((Object)group).iterator();
                for (int numToMove = defecitTsi.getExpectedDeficits().get(group).intValue(); numToMove > 0; numToMove -= transfer) {
                    TserverGroupInfo surplusTsi = (TserverGroupInfo)surplusIter.next();
                    int available = surplusTsi.getExtras().get(group);
                    if (numToMove >= available) {
                        surplusIter.remove();
                    }
                    transfer = Math.min(numToMove, available);
                    moves.move(group, transfer, surplusTsi, defecitTsi);
                    if (moves.size() < this.getMaxMigrations()) continue;
                    return;
                }
            }
        }
    }

    private void populateMigrations(Set<TabletServerId> current, List<TabletMigration> migrationsOut, Moves moves) {
        if (moves.size() == 0) {
            return;
        }
        Function<TabletId, String> partitioner = this.getPartitioner();
        for (Map.Entry<TabletId, TabletServerId> tablet : this.getLocationProvider().entrySet()) {
            String group = partitioner.apply(tablet.getKey());
            TabletServerId loc = tablet.getValue();
            if (loc == null || !current.contains(loc)) {
                migrationsOut.clear();
                return;
            }
            TabletServerId dest = moves.removeMove(loc, group);
            if (dest == null) continue;
            migrationsOut.add(new TabletMigration(tablet.getKey(), loc, dest));
            if (moves.size() != 0) continue;
            break;
        }
    }

    static class TserverGroupInfo {
        private Map<String, Integer> expectedCounts;
        private final Map<String, MutableInt> initialCounts = new HashMap<String, MutableInt>();
        private final Map<String, Integer> extraCounts = new HashMap<String, Integer>();
        private final Map<String, Integer> expectedDeficits = new HashMap<String, Integer>();
        private final TabletServerId tsi;
        private boolean finishedAdding = false;

        TserverGroupInfo(TabletServerId tsi) {
            this.tsi = tsi;
        }

        public void addGroup(String group) {
            Preconditions.checkState((!this.finishedAdding ? 1 : 0) != 0);
            MutableInt mi = this.initialCounts.get(group);
            if (mi == null) {
                mi = new MutableInt();
                this.initialCounts.put(group, mi);
            }
            mi.increment();
        }

        public void finishedAdding(Map<String, Integer> expectedCounts) {
            Preconditions.checkState((!this.finishedAdding ? 1 : 0) != 0);
            this.finishedAdding = true;
            this.expectedCounts = expectedCounts;
            for (Map.Entry<String, Integer> entry : expectedCounts.entrySet()) {
                int num;
                String group = entry.getKey();
                int expected = entry.getValue();
                MutableInt count = this.initialCounts.get(group);
                int n = num = count == null ? 0 : count.intValue();
                if (num < expected) {
                    this.expectedDeficits.put(group, expected - num);
                    continue;
                }
                if (num <= expected) continue;
                this.extraCounts.put(group, num - expected);
            }
        }

        public void moveOff(String group, int num) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkState((boolean)this.finishedAdding);
            Integer extraCount = this.extraCounts.get(group);
            String formatString = "group=%s num=%s extraCount=%s";
            Preconditions.checkArgument((extraCount != null && extraCount >= num ? 1 : 0) != 0, (String)formatString, (Object)group, (Object)num, (Object)extraCount);
            MutableInt initialCount = this.initialCounts.get(group);
            Preconditions.checkArgument((initialCount.intValue() >= num ? 1 : 0) != 0);
            initialCount.subtract(num);
            if (extraCount - num == 0) {
                this.extraCounts.remove(group);
            } else {
                this.extraCounts.put(group, extraCount - num);
            }
        }

        public void moveTo(String group, int num) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)this.expectedCounts.containsKey(group));
            Preconditions.checkState((boolean)this.finishedAdding);
            Integer deficit = this.expectedDeficits.get(group);
            if (deficit != null) {
                if (num >= deficit) {
                    this.expectedDeficits.remove(group);
                    num -= deficit.intValue();
                } else {
                    this.expectedDeficits.put(group, deficit - num);
                    num = 0;
                }
            }
            if (num > 0) {
                Integer extra = this.extraCounts.get(group);
                if (extra == null) {
                    extra = 0;
                }
                this.extraCounts.put(group, extra + num);
            }
        }

        public Map<String, Integer> getExpectedDeficits() {
            Preconditions.checkState((boolean)this.finishedAdding);
            return Collections.unmodifiableMap(this.expectedDeficits);
        }

        public Map<String, Integer> getExtras() {
            Preconditions.checkState((boolean)this.finishedAdding);
            return Collections.unmodifiableMap(this.extraCounts);
        }

        public TabletServerId getTabletServerId() {
            return this.tsi;
        }

        public int hashCode() {
            return this.tsi.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TserverGroupInfo) {
                TserverGroupInfo otgi = (TserverGroupInfo)o;
                return this.tsi.equals(otgi.tsi);
            }
            return false;
        }

        public String toString() {
            return this.tsi.toString();
        }
    }

    private static class Moves {
        private final HashBasedTable<TabletServerId, String, List<Move>> moves = HashBasedTable.create();
        private int totalMoves = 0;

        private Moves() {
        }

        public void move(String group, int num, TserverGroupInfo src, TserverGroupInfo dest) {
            Preconditions.checkArgument((num > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((!src.equals(dest) ? 1 : 0) != 0);
            src.moveOff(group, num);
            dest.moveTo(group, num);
            ArrayList<Move> srcMoves = (ArrayList<Move>)this.moves.get((Object)src.getTabletServerId(), (Object)group);
            if (srcMoves == null) {
                srcMoves = new ArrayList<Move>();
                this.moves.put((Object)src.getTabletServerId(), (Object)group, srcMoves);
            }
            srcMoves.add(new Move(dest, num));
            this.totalMoves += num;
        }

        public TabletServerId removeMove(TabletServerId src, String group) {
            List srcMoves = (List)this.moves.get((Object)src, (Object)group);
            if (srcMoves == null) {
                return null;
            }
            Move move = (Move)srcMoves.get(srcMoves.size() - 1);
            TabletServerId ret = move.dest.getTabletServerId();
            --this.totalMoves;
            --move.count;
            if (move.count == 0) {
                srcMoves.remove(srcMoves.size() - 1);
                if (srcMoves.isEmpty()) {
                    this.moves.remove((Object)src, (Object)group);
                }
            }
            return ret;
        }

        public int size() {
            return this.totalMoves;
        }
    }

    private static class Move {
        TserverGroupInfo dest;
        int count;

        public Move(TserverGroupInfo dest, int num) {
            this.dest = dest;
            this.count = num;
        }
    }
}

