/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.iteratorsImpl.conf.ColumnSet;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Combiner
extends WrappingIterator
implements OptionDescriber {
    static final Logger sawDeleteLog = LoggerFactory.getLogger((String)(Combiner.class.getName() + ".SawDelete"));
    protected static final String COLUMNS_OPTION = "columns";
    protected static final String ALL_OPTION = "all";
    protected static final String REDUCE_ON_FULL_COMPACTION_ONLY_OPTION = "reduceOnFullCompactionOnly";
    private boolean isMajorCompaction;
    private boolean reduceOnFullCompactionOnly;
    Key topKey;
    Value topValue;
    private final Key workKey = new Key();
    @VisibleForTesting
    static final Cache<String, Boolean> loggedMsgCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).maximumSize(10000L).build();
    private ColumnSet combiners;
    private boolean combineAllColumns;

    @Override
    public Key getTopKey() {
        if (this.topKey == null) {
            return super.getTopKey();
        }
        return this.topKey;
    }

    @Override
    public Value getTopValue() {
        if (this.topKey == null) {
            return super.getTopValue();
        }
        return this.topValue;
    }

    @Override
    public boolean hasTop() {
        return this.topKey != null || super.hasTop();
    }

    @Override
    public void next() throws IOException {
        if (this.topKey != null) {
            this.topKey = null;
            this.topValue = null;
        } else {
            super.next();
        }
        this.findTop();
    }

    private void sawDelete() {
        if (this.isMajorCompaction && !this.reduceOnFullCompactionOnly) {
            try {
                loggedMsgCache.get((Object)this.getClass().getName(), () -> {
                    sawDeleteLog.error("Combiner of type {} saw a delete during a partial compaction. This could cause undesired results. See ACCUMULO-2232. Will not log subsequent occurrences for at least 1 hour.", (Object)this.getClass().getSimpleName());
                    return Boolean.TRUE;
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void findTop() throws IOException {
        if (super.hasTop()) {
            this.workKey.set(super.getTopKey());
            if (this.combineAllColumns || this.combiners.contains(this.workKey)) {
                if (this.workKey.isDeleted()) {
                    this.sawDelete();
                    return;
                }
                this.topKey = this.workKey;
                ValueIterator viter = new ValueIterator(this.getSource());
                this.topValue = this.reduce(this.topKey, viter);
                while (viter.hasNext()) {
                    viter.next();
                }
            }
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        super.seek(seekRange, columnFamilies, inclusive);
        this.findTop();
        if (range.getStartKey() != null) {
            while (this.hasTop() && this.getTopKey().equals(range.getStartKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS) && this.getTopKey().getTimestamp() > range.getStartKey().getTimestamp()) {
                this.next();
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    public abstract Value reduce(Key var1, Iterator<Value> var2);

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.combineAllColumns = false;
        if (options.containsKey(ALL_OPTION)) {
            this.combineAllColumns = Boolean.parseBoolean(options.get(ALL_OPTION));
        }
        if (!this.combineAllColumns) {
            if (!options.containsKey(COLUMNS_OPTION)) {
                throw new IllegalArgumentException("Must specify columns option");
            }
            String encodedColumns = options.get(COLUMNS_OPTION);
            if (encodedColumns.isEmpty()) {
                throw new IllegalArgumentException("The columns must not be empty");
            }
            this.combiners = new ColumnSet(Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)encodedColumns)));
        }
        this.isMajorCompaction = env.getIteratorScope() == IteratorUtil.IteratorScope.majc;
        String rofco = options.get(REDUCE_ON_FULL_COMPACTION_ONLY_OPTION);
        this.reduceOnFullCompactionOnly = rofco != null ? Boolean.parseBoolean(rofco) : false;
        if (this.reduceOnFullCompactionOnly && this.isMajorCompaction && !env.isFullMajorCompaction()) {
            this.combineAllColumns = false;
            this.combiners = new ColumnSet();
        }
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        Combiner newInstance;
        try {
            newInstance = (Combiner)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        newInstance.setSource(this.getSource().deepCopy(env));
        newInstance.combiners = this.combiners;
        newInstance.combineAllColumns = this.combineAllColumns;
        newInstance.isMajorCompaction = this.isMajorCompaction;
        newInstance.reduceOnFullCompactionOnly = this.reduceOnFullCompactionOnly;
        return newInstance;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = new OptionDescriber.IteratorOptions("comb", "Combiners apply reduce functions to multiple versions of values with otherwise equal keys", null, null);
        io.addNamedOption(ALL_OPTION, "set to true to apply Combiner to every column, otherwise leave blank. if true, columns option will be ignored.");
        io.addNamedOption(COLUMNS_OPTION, "<col fam>[:<col qual>]{,<col fam>[:<col qual>]} escape non-alphanum chars using %<hex>.");
        io.addNamedOption(REDUCE_ON_FULL_COMPACTION_ONLY_OPTION, "If true, only reduce on full major compactions.  Defaults to false. ");
        return io;
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        if (options.containsKey(ALL_OPTION)) {
            try {
                this.combineAllColumns = Boolean.parseBoolean(options.get(ALL_OPTION));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("bad boolean all:" + options.get(ALL_OPTION));
            }
            if (this.combineAllColumns) {
                return true;
            }
        }
        if (!options.containsKey(COLUMNS_OPTION)) {
            throw new IllegalArgumentException("options must include all or columns");
        }
        String encodedColumns = options.get(COLUMNS_OPTION);
        if (encodedColumns.isEmpty()) {
            throw new IllegalArgumentException("empty columns specified in option columns");
        }
        for (String columns : Splitter.on((String)",").split((CharSequence)encodedColumns)) {
            if (ColumnSet.isValidEncoding(columns)) continue;
            throw new IllegalArgumentException("invalid column encoding " + encodedColumns);
        }
        return true;
    }

    public static void setColumns(IteratorSetting is, List<IteratorSetting.Column> columns) {
        String sep = "";
        StringBuilder sb = new StringBuilder();
        for (IteratorSetting.Column col : columns) {
            sb.append(sep);
            sep = ",";
            sb.append(ColumnSet.encodeColumns((Text)col.getFirst(), (Text)col.getSecond()));
        }
        is.addOption(COLUMNS_OPTION, sb.toString());
    }

    public static void setCombineAllColumns(IteratorSetting is, boolean combineAllColumns) {
        is.addOption(ALL_OPTION, Boolean.toString(combineAllColumns));
    }

    public static void setReduceOnFullCompactionOnly(IteratorSetting is, boolean reduceOnFullCompactionOnly) {
        is.addOption(REDUCE_ON_FULL_COMPACTION_ONLY_OPTION, Boolean.toString(reduceOnFullCompactionOnly));
    }

    public static class ValueIterator
    implements Iterator<Value> {
        Key topKey;
        SortedKeyValueIterator<Key, Value> source;
        boolean hasNext;

        public ValueIterator(SortedKeyValueIterator<Key, Value> source) {
            this.source = source;
            this.topKey = new Key(source.getTopKey());
            this.hasNext = this._hasNext();
        }

        private boolean _hasNext() {
            return this.source.hasTop() && !this.source.getTopKey().isDeleted() && this.topKey.equals(this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Value next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Value topValue = new Value(this.source.getTopValue());
            try {
                this.source.next();
                this.hasNext = this._hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return topValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

