/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.lru;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.spi.cache.BlockCache;
import org.apache.accumulo.core.spi.cache.CacheEntry;

public abstract class SynchronousLoadingBlockCache
implements BlockCache {
    private final Lock[] loadLocks;

    SynchronousLoadingBlockCache(int numLocks) {
        this.loadLocks = new Lock[numLocks];
        for (int i = 0; i < this.loadLocks.length; ++i) {
            this.loadLocks[i] = new ReentrantLock(true);
        }
    }

    public SynchronousLoadingBlockCache() {
        this(5003);
    }

    private Map<String, byte[]> resolveDependencies(Map<String, BlockCache.Loader> loaderDeps) {
        Map<String, byte[]> depData;
        block0 : switch (loaderDeps.size()) {
            case 0: {
                depData = Collections.emptyMap();
                break;
            }
            case 1: {
                Map.Entry<String, BlockCache.Loader> entry = loaderDeps.entrySet().iterator().next();
                CacheEntry dce = this.getBlock(entry.getKey(), entry.getValue());
                if (dce == null) {
                    depData = null;
                    break;
                }
                depData = Collections.singletonMap(entry.getKey(), dce.getBuffer());
                break;
            }
            default: {
                depData = new HashMap();
                Set<Map.Entry<String, BlockCache.Loader>> es = loaderDeps.entrySet();
                for (Map.Entry<String, BlockCache.Loader> entry : es) {
                    CacheEntry dce = this.getBlock(entry.getKey(), entry.getValue());
                    if (dce == null) {
                        depData = null;
                        break block0;
                    }
                    depData.put(entry.getKey(), dce.getBuffer());
                }
            }
        }
        return depData;
    }

    protected abstract int getMaxEntrySize();

    protected abstract CacheEntry getBlockNoStats(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry getBlock(String blockName, BlockCache.Loader loader) {
        CacheEntry ce = this.getBlock(blockName);
        if (ce != null) {
            return ce;
        }
        Map<String, byte[]> depData = this.resolveDependencies(loader.getDependencies());
        if (depData == null) {
            return null;
        }
        int lockIndex = (blockName.hashCode() & Integer.MAX_VALUE) % this.loadLocks.length;
        Lock loadLock = this.loadLocks[lockIndex];
        loadLock.lock();
        try {
            ce = this.getBlockNoStats(blockName);
            if (ce != null) {
                CacheEntry cacheEntry = ce;
                return cacheEntry;
            }
            byte[] data = loader.load(this.getMaxEntrySize(), depData);
            if (data == null) {
                CacheEntry cacheEntry = null;
                return cacheEntry;
            }
            CacheEntry cacheEntry = this.cacheBlock(blockName, data);
            return cacheEntry;
        }
        finally {
            loadLock.unlock();
        }
    }
}

