/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.cache.impl;

public class ClassSize {
    public static final int ARRAY;
    public static final int BYTE_BUFFER;
    public static final int OBJECT;
    public static final int REFERENCE;
    public static final int STRING;
    public static final int CONCURRENT_HASHMAP;
    public static final int CONCURRENT_HASHMAP_ENTRY;
    public static final int CONCURRENT_HASHMAP_SEGMENT;
    public static final int ATOMIC_INTEGER;
    private static final String THIRTY_TWO = "32";

    public static int align(int num) {
        return (int)ClassSize.align((long)num);
    }

    public static long align(long num) {
        return num + 7L >> 3 << 3;
    }

    static {
        String arcModel = System.getProperty("sun.arch.data.model");
        REFERENCE = arcModel.equals(THIRTY_TWO) ? 4 : 8;
        OBJECT = 2 * REFERENCE;
        ARRAY = 3 * REFERENCE;
        BYTE_BUFFER = ClassSize.align(OBJECT + ClassSize.align(REFERENCE) + ClassSize.align(ARRAY) + 20 + 3 + 8);
        STRING = ClassSize.align(OBJECT + ARRAY + REFERENCE + 12);
        CONCURRENT_HASHMAP = ClassSize.align(8 + ARRAY + 6 * REFERENCE + OBJECT);
        CONCURRENT_HASHMAP_ENTRY = ClassSize.align(REFERENCE + OBJECT + 3 * REFERENCE + 8);
        CONCURRENT_HASHMAP_SEGMENT = ClassSize.align(REFERENCE + OBJECT + 12 + 4 + ARRAY);
        ATOMIC_INTEGER = ClassSize.align(OBJECT + 4);
    }
}

