/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.ReplicationOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.BatchWriterImpl;
import org.apache.accumulo.core.clientImpl.ClientConfConverter;
import org.apache.accumulo.core.clientImpl.ClientInfo;
import org.apache.accumulo.core.clientImpl.ClientInfoImpl;
import org.apache.accumulo.core.clientImpl.ClientServiceEnvironmentImpl;
import org.apache.accumulo.core.clientImpl.ConditionalWriterImpl;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.InstanceOperationsImpl;
import org.apache.accumulo.core.clientImpl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.clientImpl.NamespaceOperationsImpl;
import org.apache.accumulo.core.clientImpl.ReplicationOperationsImpl;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.SecurityOperationsImpl;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.TabletServerBatchDeleter;
import org.apache.accumulo.core.clientImpl.TabletServerBatchReader;
import org.apache.accumulo.core.clientImpl.ThriftTransportPool;
import org.apache.accumulo.core.clientImpl.ZookeeperLockChecker;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.KeyValue;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.AmpleImpl;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.singletons.SingletonReservation;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.core.spi.scan.ScanServerInfo;
import org.apache.accumulo.core.spi.scan.ScanServerSelector;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.core.util.tables.TableZooHelper;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientContext
implements AccumuloClient {
    private static final Logger log = LoggerFactory.getLogger(ClientContext.class);
    private final ClientInfo info;
    private InstanceId instanceId;
    private final ZooReader zooReader;
    private final ZooCache zooCache;
    private Credentials creds;
    private BatchWriterConfig batchWriterConfig;
    private ConditionalWriterConfig conditionalWriterConfig;
    private final AccumuloConfiguration serverConf;
    private final Configuration hadoopConf;
    private final Supplier<Long> timeoutSupplier;
    private final Supplier<SaslConnectionParams> saslSupplier;
    private final Supplier<SslConnectionParams> sslSupplier;
    private final Supplier<ScanServerSelector> scanServerSelectorSupplier;
    private TCredentials rpcCreds;
    private ThriftTransportPool thriftTransportPool;
    private ZookeeperLockChecker zkLockChecker;
    private volatile boolean closed = false;
    private SecurityOperations secops = null;
    private final TableOperationsImpl tableops;
    private final NamespaceOperations namespaceops;
    private InstanceOperations instanceops = null;
    private ReplicationOperations replicationops = null;
    private final SingletonReservation singletonReservation;
    private final Supplier<ThreadPools> clientThreadPools;
    private ThreadPoolExecutor cleanupThreadPool;
    private ThreadPoolExecutor scannerReadaheadPool;
    private TableZooHelper tableZooHelper;

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("This client was closed.");
        }
    }

    protected boolean isClosed() {
        return this.closed;
    }

    private ScanServerSelector createScanServerSelector() {
        String clazz = ClientProperty.SCAN_SERVER_SELECTOR.getValue(this.info.getProperties());
        try {
            Class<ScanServerSelector> impl = Class.forName(clazz).asSubclass(ScanServerSelector.class);
            ScanServerSelector scanServerSelector = impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            final HashMap sserverProps = new HashMap();
            ClientProperty.getPrefix(this.info.getProperties(), ClientProperty.SCAN_SERVER_SELECTOR_OPTS_PREFIX.getKey()).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sserverProps.put(k.toString().substring(ClientProperty.SCAN_SERVER_SELECTOR_OPTS_PREFIX.getKey().length()), v.toString())));
            scanServerSelector.init(new ScanServerSelector.InitParameters(){

                @Override
                public Map<String, String> getOptions() {
                    return Collections.unmodifiableMap(sserverProps);
                }

                @Override
                public ServiceEnvironment getServiceEnv() {
                    return new ClientServiceEnvironmentImpl(ClientContext.this);
                }

                @Override
                public Supplier<Collection<ScanServerInfo>> getScanServers() {
                    return () -> ClientContext.this.getScanServers().entrySet().stream().map(entry -> new ScanServerInfo(){
                        final /* synthetic */ Map.Entry val$entry;
                        {
                            this.val$entry = entry;
                        }

                        @Override
                        public String getAddress() {
                            return (String)this.val$entry.getKey();
                        }

                        @Override
                        public String getGroup() {
                            return (String)((Pair)this.val$entry.getValue()).getSecond();
                        }
                    }).collect(Collectors.toSet());
                }
            });
            return scanServerSelector;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException("Error creating ScanServerSelector implementation: " + clazz, e);
        }
    }

    public ClientContext(SingletonReservation reservation, ClientInfo info, AccumuloConfiguration serverConf, Thread.UncaughtExceptionHandler ueh) {
        this.info = info;
        this.hadoopConf = info.getHadoopConf();
        this.zooReader = new ZooReader(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
        this.zooCache = new ZooCacheFactory().getZooCache(info.getZooKeepers(), info.getZooKeepersSessionTimeOut());
        this.serverConf = serverConf;
        this.timeoutSupplier = Suppliers.memoizeWithExpiration(() -> this.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.sslSupplier = Suppliers.memoize(() -> SslConnectionParams.forClient(this.getConfiguration()));
        this.saslSupplier = Suppliers.memoizeWithExpiration(() -> SaslConnectionParams.from(this.getConfiguration(), this.getCredentials().getToken()), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.scanServerSelectorSupplier = Suppliers.memoize(this::createScanServerSelector);
        this.singletonReservation = Objects.requireNonNull(reservation);
        this.tableops = new TableOperationsImpl(this);
        this.namespaceops = new NamespaceOperationsImpl(this, this.tableops);
        this.clientThreadPools = ueh == Threads.UEH ? () -> ThreadPools.getServerThreadPools() : (ueh == null ? () -> ThreadPools.getClientThreadPools(this.getConfiguration(), (t, e) -> log.error("Caught an Exception in client background thread: {}. Thread is dead.", (Object)t, (Object)e)) : () -> ThreadPools.getClientThreadPools(this.getConfiguration(), ueh));
    }

    public Ample getAmple() {
        this.ensureOpen();
        return new AmpleImpl(this);
    }

    public synchronized Future<List<KeyValue>> submitScannerReadAheadTask(Callable<List<KeyValue>> c) {
        this.ensureOpen();
        if (this.scannerReadaheadPool == null) {
            this.scannerReadaheadPool = this.clientThreadPools.get().getPoolBuilder(ThreadPoolNames.SCANNER_READ_AHEAD_POOL).numCoreThreads(0).numMaxThreads(Integer.MAX_VALUE).withTimeOut(3L, TimeUnit.SECONDS).withQueue(new SynchronousQueue<Runnable>()).build();
        }
        return this.scannerReadaheadPool.submit(c);
    }

    public synchronized void executeCleanupTask(Runnable r) {
        this.ensureOpen();
        if (this.cleanupThreadPool == null) {
            this.cleanupThreadPool = this.clientThreadPools.get().getPoolBuilder(ThreadPoolNames.CONDITIONAL_WRITER_CLEANUP_POOL).numCoreThreads(1).withTimeOut(3L, TimeUnit.SECONDS).build();
        }
        this.cleanupThreadPool.execute(r);
    }

    public ThreadPools threadPools() {
        this.ensureOpen();
        return this.clientThreadPools.get();
    }

    public synchronized Credentials getCredentials() {
        this.ensureOpen();
        if (this.creds == null) {
            this.creds = new Credentials(this.info.getPrincipal(), this.info.getAuthenticationToken());
        }
        return this.creds;
    }

    public String getPrincipal() {
        this.ensureOpen();
        return this.getCredentials().getPrincipal();
    }

    public AuthenticationToken getAuthenticationToken() {
        this.ensureOpen();
        return this.getCredentials().getToken();
    }

    public Properties getProperties() {
        this.ensureOpen();
        return this.info.getProperties();
    }

    public synchronized void setCredentials(Credentials newCredentials) {
        this.ensureOpen();
        Preconditions.checkArgument((newCredentials != null ? 1 : 0) != 0, (Object)"newCredentials is null");
        this.creds = newCredentials;
        this.rpcCreds = null;
    }

    public AccumuloConfiguration getConfiguration() {
        this.ensureOpen();
        return this.serverConf;
    }

    public Configuration getHadoopConf() {
        this.ensureOpen();
        return this.hadoopConf;
    }

    public long getClientTimeoutInMillis() {
        this.ensureOpen();
        return this.timeoutSupplier.get();
    }

    public SslConnectionParams getClientSslParams() {
        this.ensureOpen();
        return this.sslSupplier.get();
    }

    public SaslConnectionParams getSaslParams() {
        this.ensureOpen();
        return this.saslSupplier.get();
    }

    static BatchWriterConfig getBatchWriterConfig(Properties props) {
        String durability;
        Integer maxThreads;
        Long timeout;
        Long maxLatency;
        BatchWriterConfig batchWriterConfig = new BatchWriterConfig();
        Long maxMemory = ClientProperty.BATCH_WRITER_MEMORY_MAX.getBytes(props);
        if (maxMemory != null) {
            batchWriterConfig.setMaxMemory(maxMemory);
        }
        if ((maxLatency = ClientProperty.BATCH_WRITER_LATENCY_MAX.getTimeInMillis(props)) != null) {
            batchWriterConfig.setMaxLatency(maxLatency, TimeUnit.MILLISECONDS);
        }
        if ((timeout = ClientProperty.BATCH_WRITER_TIMEOUT_MAX.getTimeInMillis(props)) != null) {
            batchWriterConfig.setTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        if ((maxThreads = ClientProperty.BATCH_WRITER_THREADS_MAX.getInteger(props)) != null) {
            batchWriterConfig.setMaxWriteThreads(maxThreads);
        }
        if (!(durability = ClientProperty.BATCH_WRITER_DURABILITY.getValue(props)).isEmpty()) {
            batchWriterConfig.setDurability(Durability.valueOf(durability.toUpperCase()));
        }
        return batchWriterConfig;
    }

    public synchronized BatchWriterConfig getBatchWriterConfig() {
        this.ensureOpen();
        if (this.batchWriterConfig == null) {
            this.batchWriterConfig = ClientContext.getBatchWriterConfig(this.info.getProperties());
        }
        return this.batchWriterConfig;
    }

    public Map<String, Pair<UUID, String>> getScanServers() {
        HashMap<String, Pair<UUID, String>> liveScanServers = new HashMap<String, Pair<UUID, String>>();
        String root = this.getZooKeeperRoot() + "/sservers";
        List<String> addrs = this.getZooCache().getChildren(root);
        for (String addr : addrs) {
            try {
                ServiceLock.ServiceLockPath zLockPath = ServiceLock.path(root + "/" + addr);
                ZooCache.ZcStat stat = new ZooCache.ZcStat();
                byte[] lockData = ServiceLock.getLockData(this.getZooCache(), zLockPath, stat);
                if (lockData == null) continue;
                String[] fields = new String(lockData, StandardCharsets.UTF_8).split(",", 2);
                UUID uuid = UUID.fromString(fields[0]);
                String group = fields[1];
                liveScanServers.put(addr, new Pair<UUID, String>(uuid, group));
            }
            catch (IllegalArgumentException e) {
                log.error("Error validating zookeeper scan server node: " + addr, (Throwable)e);
            }
        }
        return liveScanServers;
    }

    public ScanServerSelector getScanServerSelector() {
        this.ensureOpen();
        return this.scanServerSelectorSupplier.get();
    }

    static ConditionalWriterConfig getConditionalWriterConfig(Properties props) {
        Integer maxThreads;
        String durability;
        ConditionalWriterConfig conditionalWriterConfig = new ConditionalWriterConfig();
        Long timeout = ClientProperty.CONDITIONAL_WRITER_TIMEOUT_MAX.getTimeInMillis(props);
        if (timeout != null) {
            conditionalWriterConfig.setTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        if (!(durability = ClientProperty.CONDITIONAL_WRITER_DURABILITY.getValue(props)).isEmpty()) {
            conditionalWriterConfig.setDurability(Durability.valueOf(durability.toUpperCase()));
        }
        if ((maxThreads = ClientProperty.CONDITIONAL_WRITER_THREADS_MAX.getInteger(props)) != null) {
            conditionalWriterConfig.setMaxWriteThreads(maxThreads);
        }
        return conditionalWriterConfig;
    }

    public synchronized ConditionalWriterConfig getConditionalWriterConfig() {
        this.ensureOpen();
        if (this.conditionalWriterConfig == null) {
            this.conditionalWriterConfig = ClientContext.getConditionalWriterConfig(this.info.getProperties());
        }
        return this.conditionalWriterConfig;
    }

    public synchronized TCredentials rpcCreds() {
        this.ensureOpen();
        if (this.getCredentials().getToken().isDestroyed()) {
            this.rpcCreds = null;
        }
        if (this.rpcCreds == null) {
            this.rpcCreds = this.getCredentials().toThrift(this.getInstanceID());
        }
        return this.rpcCreds;
    }

    public String getRootTabletLocation() {
        this.ensureOpen();
        Timer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up root tablet location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = Timer.startNew();
        }
        TabletMetadata.Location loc = this.getAmple().readTablet(RootTable.EXTENT, Ample.ReadConsistency.EVENTUAL, TabletMetadata.ColumnType.LOCATION).getLocation();
        if (timer != null) {
            log.trace("tid={} Found root tablet at {} in {}", new Object[]{Thread.currentThread().getId(), loc, String.format("%.3f secs", (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0)});
        }
        if (loc == null || loc.getType() != TabletMetadata.LocationType.CURRENT) {
            return null;
        }
        return loc.getHostPort();
    }

    public List<String> getManagerLocations() {
        this.ensureOpen();
        return ClientContext.getManagerLocations(this.zooCache, this.getInstanceID().canonical());
    }

    public static List<String> getManagerLocations(ZooCache zooCache, String instanceId) {
        ServiceLock.ServiceLockPath zLockManagerPath = ServiceLock.path("/accumulo/" + instanceId + "/managers/lock");
        Timer timer = null;
        if (log.isTraceEnabled()) {
            log.trace("tid={} Looking up manager location in zookeeper.", (Object)Thread.currentThread().getId());
            timer = Timer.startNew();
        }
        byte[] loc = zooCache.getLockData(zLockManagerPath);
        if (timer != null) {
            log.trace("tid={} Found manager at {} in {}", new Object[]{Thread.currentThread().getId(), loc == null ? "null" : new String(loc, StandardCharsets.UTF_8), String.format("%.3f secs", (double)timer.elapsed(TimeUnit.MILLISECONDS) / 1000.0)});
        }
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, StandardCharsets.UTF_8));
    }

    public InstanceId getInstanceID() {
        this.ensureOpen();
        if (this.instanceId == null) {
            String instanceName = this.info.getInstanceName();
            this.instanceId = ClientContext.getInstanceID(this.zooCache, instanceName);
            ClientContext.verifyInstanceId(this.zooCache, this.instanceId.canonical(), instanceName);
        }
        return this.instanceId;
    }

    public static InstanceId getInstanceID(ZooCache zooCache, String instanceName) {
        Objects.requireNonNull(zooCache, "zooCache cannot be null");
        Objects.requireNonNull(instanceName, "instanceName cannot be null");
        String instanceNamePath = "/accumulo/instances/" + instanceName;
        byte[] data = zooCache.get(instanceNamePath);
        if (data == null) {
            throw new RuntimeException("Instance name " + instanceName + " does not exist in zookeeper. Run \"accumulo org.apache.accumulo.server.util.ListInstances\" to see a list.");
        }
        return InstanceId.of(new String(data, StandardCharsets.UTF_8));
    }

    public static void verifyInstanceId(ZooCache zooCache, String instanceId, String instanceName) {
        Objects.requireNonNull(zooCache, "zooCache cannot be null");
        Objects.requireNonNull(instanceId, "instanceId cannot be null");
        if (zooCache.get("/accumulo/" + instanceId) == null) {
            throw new RuntimeException("Instance id " + instanceId + (String)(instanceName == null ? "" : " pointed to by the name " + instanceName) + " does not exist in zookeeper");
        }
    }

    public String getZooKeeperRoot() {
        this.ensureOpen();
        return ZooUtil.getRoot(this.getInstanceID());
    }

    public String getInstanceName() {
        this.ensureOpen();
        return this.info.getInstanceName();
    }

    public String getZooKeepers() {
        this.ensureOpen();
        return this.info.getZooKeepers();
    }

    public int getZooKeepersSessionTimeOut() {
        this.ensureOpen();
        return this.info.getZooKeepersSessionTimeOut();
    }

    public ZooCache getZooCache() {
        this.ensureOpen();
        return this.zooCache;
    }

    private synchronized TableZooHelper tableZooHelper() {
        this.ensureOpen();
        if (this.tableZooHelper == null) {
            this.tableZooHelper = new TableZooHelper(this);
        }
        return this.tableZooHelper;
    }

    public TableId getTableId(String tableName) throws TableNotFoundException {
        return this.tableZooHelper().getTableId(tableName);
    }

    public TableId _getTableIdDetectNamespaceNotFound(String tableName) throws NamespaceNotFoundException, TableNotFoundException {
        return this.tableZooHelper()._getTableIdDetectNamespaceNotFound(tableName);
    }

    public String getTableName(TableId tableId) throws TableNotFoundException {
        return this.tableZooHelper().getTableName(tableId);
    }

    public Map<String, TableId> getTableNameToIdMap() {
        return this.tableZooHelper().getTableMap().getNameToIdMap();
    }

    public Map<TableId, String> getTableIdToNameMap() {
        return this.tableZooHelper().getTableMap().getIdtoNameMap();
    }

    public boolean tableNodeExists(TableId tableId) {
        return this.tableZooHelper().tableNodeExists(tableId);
    }

    public void clearTableListCache() {
        this.tableZooHelper().clearTableListCache();
    }

    public String getPrintableTableInfoFromId(TableId tableId) {
        return this.tableZooHelper().getPrintableTableInfoFromId(tableId);
    }

    public String getPrintableTableInfoFromName(String tableName) {
        return this.tableZooHelper().getPrintableTableInfoFromName(tableName);
    }

    public TableState getTableState(TableId tableId) {
        return this.tableZooHelper().getTableState(tableId, false);
    }

    public TableState getTableState(TableId tableId, boolean clearCachedState) {
        return this.tableZooHelper().getTableState(tableId, clearCachedState);
    }

    public NamespaceId getNamespaceId(TableId tableId) throws TableNotFoundException {
        return this.tableZooHelper().getNamespaceId(tableId);
    }

    public TableId requireTableExists(TableId tableId, String tableName) throws TableNotFoundException {
        if (!this.tableNodeExists(tableId)) {
            throw new TableNotFoundException(tableId.canonical(), tableName, "Table no longer exists");
        }
        return tableId;
    }

    public TableId requireNotDeleted(TableId tableId) {
        if (!this.tableNodeExists(tableId)) {
            throw new TableDeletedException(tableId.canonical());
        }
        return tableId;
    }

    public TableId requireNotOffline(TableId tableId, String tableName) {
        if (this.getTableState(tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(tableId, tableName);
        }
        return tableId;
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        this.ensureOpen();
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new TabletServerBatchReader(this, this.requireNotOffline(this.getTableId(tableName), tableName), tableName, authorizations, numQueryThreads);
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        this.ensureOpen();
        Integer numQueryThreads = ClientProperty.BATCH_SCANNER_NUM_QUERY_THREADS.getInteger(this.getProperties());
        Objects.requireNonNull(numQueryThreads);
        return this.createBatchScanner(tableName, authorizations, numQueryThreads);
    }

    @Override
    public BatchScanner createBatchScanner(String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        Authorizations auths = this.securityOperations().getUserAuthorizations(this.getPrincipal());
        return this.createBatchScanner(tableName, auths);
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        this.ensureOpen();
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        return new TabletServerBatchDeleter(this, this.requireNotOffline(this.getTableId(tableName), tableName), tableName, authorizations, numQueryThreads, config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        this.ensureOpen();
        return this.createBatchDeleter(tableName, authorizations, numQueryThreads, new BatchWriterConfig());
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        this.ensureOpen();
        if (config == null) {
            config = new BatchWriterConfig();
        }
        return new BatchWriterImpl(this, this.requireNotOffline(this.getTableId(tableName), tableName), config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName) throws TableNotFoundException {
        return this.createBatchWriter(tableName, new BatchWriterConfig());
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        this.ensureOpen();
        return new MultiTableBatchWriterImpl(this, config.merge(this.getBatchWriterConfig()));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter() {
        return this.createMultiTableBatchWriter(new BatchWriterConfig());
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName, ConditionalWriterConfig config) throws TableNotFoundException {
        this.ensureOpen();
        if (config == null) {
            config = new ConditionalWriterConfig();
        }
        return new ConditionalWriterImpl(this, this.requireNotOffline(this.getTableId(tableName), tableName), tableName, config.merge(this.getConditionalWriterConfig()));
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName) throws TableNotFoundException {
        return this.createConditionalWriter(tableName, null);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        this.ensureOpen();
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        ScannerImpl scanner = new ScannerImpl(this, this.requireNotOffline(this.getTableId(tableName), tableName), authorizations);
        Integer batchSize = ClientProperty.SCANNER_BATCH_SIZE.getInteger(this.getProperties());
        if (batchSize != null) {
            scanner.setBatchSize(batchSize);
        }
        return scanner;
    }

    @Override
    public Scanner createScanner(String tableName) throws TableNotFoundException, AccumuloSecurityException, AccumuloException {
        Authorizations auths = this.securityOperations().getUserAuthorizations(this.getPrincipal());
        return this.createScanner(tableName, auths);
    }

    @Override
    public String whoami() {
        this.ensureOpen();
        return this.getCredentials().getPrincipal();
    }

    @Override
    public synchronized TableOperations tableOperations() {
        this.ensureOpen();
        return this.tableops;
    }

    @Override
    public synchronized NamespaceOperations namespaceOperations() {
        this.ensureOpen();
        return this.namespaceops;
    }

    @Override
    public synchronized SecurityOperations securityOperations() {
        this.ensureOpen();
        if (this.secops == null) {
            this.secops = new SecurityOperationsImpl(this);
        }
        return this.secops;
    }

    @Override
    public synchronized InstanceOperations instanceOperations() {
        this.ensureOpen();
        if (this.instanceops == null) {
            this.instanceops = new InstanceOperationsImpl(this);
        }
        return this.instanceops;
    }

    @Override
    @Deprecated
    public synchronized ReplicationOperations replicationOperations() {
        this.ensureOpen();
        if (this.replicationops == null) {
            this.replicationops = new ReplicationOperationsImpl(this);
        }
        return this.replicationops;
    }

    @Override
    public Properties properties() {
        this.ensureOpen();
        Properties result = new Properties();
        this.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!key.equals(ClientProperty.AUTH_TOKEN.getKey())) {
                result.setProperty((String)key, (String)value);
            }
        }));
        return result;
    }

    public AuthenticationToken token() {
        this.ensureOpen();
        return this.getAuthenticationToken();
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (this.thriftTransportPool != null) {
            this.thriftTransportPool.shutdown();
        }
        if (this.tableZooHelper != null) {
            this.tableZooHelper.close();
        }
        if (this.scannerReadaheadPool != null) {
            this.scannerReadaheadPool.shutdownNow();
        }
        if (this.cleanupThreadPool != null) {
            this.cleanupThreadPool.shutdown();
        }
        this.singletonReservation.close();
    }

    public ZooReader getZooReader() {
        this.ensureOpen();
        return this.zooReader;
    }

    protected long getTransportPoolMaxAgeMillis() {
        this.ensureOpen();
        return ClientProperty.RPC_TRANSPORT_IDLE_TIMEOUT.getTimeInMillis(this.getProperties());
    }

    public synchronized ThriftTransportPool getTransportPool() {
        return this.getTransportPoolImpl(false);
    }

    protected synchronized ThriftTransportPool getTransportPoolImpl(boolean shouldHalt) {
        this.ensureOpen();
        if (this.thriftTransportPool == null) {
            this.thriftTransportPool = ThriftTransportPool.startNew(this::getTransportPoolMaxAgeMillis, shouldHalt);
        }
        return this.thriftTransportPool;
    }

    public synchronized ZookeeperLockChecker getTServerLockChecker() {
        this.ensureOpen();
        if (this.zkLockChecker == null) {
            this.zkLockChecker = new ZookeeperLockChecker(this);
        }
        return this.zkLockChecker;
    }

    public static class ClientBuilderImpl<T>
    implements AccumuloClient.InstanceArgs<T>,
    AccumuloClient.PropertyOptions<T>,
    AccumuloClient.AuthenticationArgs<T>,
    AccumuloClient.ConnectionOptions<T>,
    AccumuloClient.SslOptions<T>,
    AccumuloClient.SaslOptions<T>,
    AccumuloClient.ClientFactory<T>,
    AccumuloClient.FromOptions<T> {
        private Properties properties = new Properties();
        private AuthenticationToken token = null;
        private final Function<ClientBuilderImpl<T>, T> builderFunction;
        private Thread.UncaughtExceptionHandler ueh = null;

        public ClientBuilderImpl(Function<ClientBuilderImpl<T>, T> builderFunction) {
            this.builderFunction = builderFunction;
        }

        private ClientInfo getClientInfo() {
            if (this.token != null) {
                ClientProperty.validate(this.properties, false);
                return new ClientInfoImpl(this.properties, this.token);
            }
            ClientProperty.validate(this.properties);
            return new ClientInfoImpl(this.properties);
        }

        private Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return this.ueh;
        }

        @Override
        public T build() {
            return this.builderFunction.apply(this);
        }

        public static AccumuloClient buildClient(ClientBuilderImpl<AccumuloClient> cbi) {
            SingletonReservation reservation = SingletonManager.getClientReservation();
            try {
                ClientInfo info = cbi.getClientInfo();
                AccumuloConfiguration config = ClientConfConverter.toAccumuloConf(info.getProperties());
                return new ClientContext(reservation, info, config, cbi.getUncaughtExceptionHandler());
            }
            catch (RuntimeException e) {
                reservation.close();
                throw e;
            }
        }

        public static Properties buildProps(ClientBuilderImpl<Properties> cbi) {
            ClientProperty.validate(cbi.properties);
            return cbi.properties;
        }

        @Override
        public AccumuloClient.AuthenticationArgs<T> to(CharSequence instanceName, CharSequence zookeepers) {
            this.setProperty(ClientProperty.INSTANCE_NAME, instanceName);
            this.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS, zookeepers);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> truststore(CharSequence path) {
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PATH, path);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> truststore(CharSequence path, CharSequence password, CharSequence type) {
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PATH, path);
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_PASSWORD, password);
            this.setProperty(ClientProperty.SSL_TRUSTSTORE_TYPE, type);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> keystore(CharSequence path) {
            this.setProperty(ClientProperty.SSL_KEYSTORE_PATH, path);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> keystore(CharSequence path, CharSequence password, CharSequence type) {
            this.setProperty(ClientProperty.SSL_KEYSTORE_PATH, path);
            this.setProperty(ClientProperty.SSL_KEYSTORE_PASSWORD, password);
            this.setProperty(ClientProperty.SSL_KEYSTORE_TYPE, type);
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> useJsse() {
            this.setProperty(ClientProperty.SSL_USE_JSSE, "true");
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> zkTimeout(int timeout) {
            ClientProperty.INSTANCE_ZOOKEEPERS_TIMEOUT.setTimeInMillis(this.properties, Long.valueOf(timeout));
            return this;
        }

        @Override
        public AccumuloClient.SslOptions<T> useSsl() {
            this.setProperty(ClientProperty.SSL_ENABLED, "true");
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> useSasl() {
            this.setProperty(ClientProperty.SASL_ENABLED, "true");
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> batchWriterConfig(BatchWriterConfig batchWriterConfig) {
            ClientProperty.BATCH_WRITER_MEMORY_MAX.setBytes(this.properties, batchWriterConfig.getMaxMemory());
            ClientProperty.BATCH_WRITER_LATENCY_MAX.setTimeInMillis(this.properties, batchWriterConfig.getMaxLatency(TimeUnit.MILLISECONDS));
            ClientProperty.BATCH_WRITER_TIMEOUT_MAX.setTimeInMillis(this.properties, batchWriterConfig.getTimeout(TimeUnit.MILLISECONDS));
            this.setProperty(ClientProperty.BATCH_WRITER_THREADS_MAX, batchWriterConfig.getMaxWriteThreads());
            this.setProperty(ClientProperty.BATCH_WRITER_DURABILITY, batchWriterConfig.getDurability().toString());
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> batchScannerQueryThreads(int numQueryThreads) {
            this.setProperty(ClientProperty.BATCH_SCANNER_NUM_QUERY_THREADS, numQueryThreads);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> scannerBatchSize(int batchSize) {
            this.setProperty(ClientProperty.SCANNER_BATCH_SIZE, batchSize);
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> primary(CharSequence kerberosServerPrimary) {
            this.setProperty(ClientProperty.SASL_KERBEROS_SERVER_PRIMARY, kerberosServerPrimary);
            return this;
        }

        @Override
        public AccumuloClient.SaslOptions<T> qop(CharSequence qualityOfProtection) {
            this.setProperty(ClientProperty.SASL_QOP, qualityOfProtection);
            return this;
        }

        @Override
        public AccumuloClient.FromOptions<T> from(String propertiesFilePath) {
            return this.from(ClientInfoImpl.toProperties(propertiesFilePath));
        }

        @Override
        public AccumuloClient.FromOptions<T> from(Path propertiesFile) {
            return this.from(ClientInfoImpl.toProperties(propertiesFile));
        }

        @Override
        public AccumuloClient.FromOptions<T> from(URL propertiesURL) {
            return this.from(ClientInfoImpl.toProperties(propertiesURL));
        }

        @Override
        public AccumuloClient.FromOptions<T> from(Properties properties) {
            this.properties = new Properties();
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence username, CharSequence password) {
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, username);
            ClientProperty.setPassword(this.properties, password);
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence principal, Path keyTabFile) {
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, principal);
            ClientProperty.setKerberosKeytab(this.properties, keyTabFile.toString());
            return this;
        }

        @Override
        public AccumuloClient.ConnectionOptions<T> as(CharSequence principal, AuthenticationToken token) {
            if (token.isDestroyed()) {
                throw new IllegalArgumentException("AuthenticationToken has been destroyed");
            }
            this.setProperty(ClientProperty.AUTH_PRINCIPAL, principal.toString());
            ClientProperty.setAuthenticationToken(this.properties, token);
            this.token = token;
            return this;
        }

        public void setProperty(ClientProperty property, CharSequence value) {
            this.properties.setProperty(property.getKey(), value.toString());
        }

        public void setProperty(ClientProperty property, Long value) {
            this.setProperty(property, Long.toString(value));
        }

        public void setProperty(ClientProperty property, Integer value) {
            this.setProperty(property, Integer.toString(value));
        }

        @Override
        public AccumuloClient.ClientFactory<T> withUncaughtExceptionHandler(Thread.UncaughtExceptionHandler ueh) {
            this.ueh = ueh;
            return this;
        }
    }
}

