/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.apache.accumulo.manager.tableOps.clone.CloneMetadata;

class CloneZookeeper
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final CloneInfo cloneInfo;

    public CloneZookeeper(CloneInfo cloneInfo, ClientContext context) throws NamespaceNotFoundException {
        this.cloneInfo = cloneInfo;
        if (this.cloneInfo.getNamespaceId() == null) {
            this.cloneInfo.setNamespaceId(Namespaces.getNamespaceId((ClientContext)context, (String)((String)TableNameUtil.qualify((String)this.cloneInfo.getTableName()).getFirst())));
        }
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        return Utils.reserveTable(environment, this.cloneInfo.getTableId(), tid, true, false, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableNameDoesNotExist(environment.getContext(), this.cloneInfo.getTableName(), this.cloneInfo.getNamespaceId(), this.cloneInfo.getTableId(), TableOperation.CLONE);
            environment.getTableManager().cloneTable(this.cloneInfo.getSrcTableId(), this.cloneInfo.getTableId(), this.cloneInfo.getTableName(), this.cloneInfo.getNamespaceId(), this.cloneInfo.getPropertiesToSet(), this.cloneInfo.getPropertiesToExclude());
            environment.getContext().clearTableListCache();
            CloneMetadata cloneMetadata = new CloneMetadata(this.cloneInfo);
            return cloneMetadata;
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        environment.getTableManager().removeTable(this.cloneInfo.getTableId());
        Utils.unreserveTable(environment, this.cloneInfo.getTableId(), tid, true);
        environment.getContext().clearTableListCache();
    }
}

