/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.manager.Manager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerTime {
    private static final Logger log = LoggerFactory.getLogger(ManagerTime.class);
    private final String zPath;
    private final ZooReaderWriter zk;
    private final Manager manager;
    private final AtomicLong skewAmount;

    public ManagerTime(Manager manager, AccumuloConfiguration conf) throws IOException {
        this.zPath = manager.getZooKeeperRoot() + "/managers/tick";
        this.zk = manager.getContext().getZooReaderWriter();
        this.manager = manager;
        try {
            this.zk.putPersistentData(this.zPath, "0".getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.SKIP);
            this.skewAmount = new AtomicLong(Long.parseLong(new String(this.zk.getData(this.zPath), StandardCharsets.UTF_8)) - System.nanoTime());
        }
        catch (Exception ex) {
            throw new IOException("Error updating manager time", ex);
        }
        ThreadPools.watchCriticalScheduledTask(manager.getContext().getScheduledExecutor().scheduleWithFixedDelay(Threads.createNamedRunnable((String)"Manager time keeper", () -> this.run()), 0L, TimeUnit.SECONDS.toMillis(10L), TimeUnit.MILLISECONDS));
    }

    public long getTime() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() + this.skewAmount.get());
    }

    public void run() {
        switch (this.manager.getManagerState()) {
            case INITIAL: 
            case STOP: {
                try {
                    long zkTime = Long.parseLong(new String(this.zk.getData(this.zPath), StandardCharsets.UTF_8));
                    this.skewAmount.set(zkTime - System.nanoTime());
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Failed to retrieve manager tick time", (Throwable)ex);
                }
                break;
            }
            case HAVE_LOCK: 
            case SAFE_MODE: 
            case NORMAL: 
            case UNLOAD_METADATA_TABLETS: 
            case UNLOAD_ROOT_TABLET: {
                try {
                    this.zk.putPersistentData(this.zPath, Long.toString(System.nanoTime() + this.skewAmount.get()).getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
                    break;
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("Failed to update manager tick time", (Throwable)ex);
                }
            }
        }
    }
}

