/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectWriteAheadLogs {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectWriteAheadLogs.class);
    private final ServerContext context;
    private final VolumeManager fs;
    private final boolean useTrash;
    private final LiveTServerSet liveServers;
    private final WalStateManager walMarker;
    private final AtomicBoolean hasCollected = new AtomicBoolean(false);
    private final Stream<TabletLocationState> store;

    GarbageCollectWriteAheadLogs(ServerContext context, VolumeManager fs, LiveTServerSet liveServers, boolean useTrash) {
        this(context, fs, liveServers, useTrash, new WalStateManager(context), GarbageCollectWriteAheadLogs.createStore(context));
    }

    GarbageCollectWriteAheadLogs(ServerContext context, VolumeManager fs, LiveTServerSet liveServers, boolean useTrash, WalStateManager walMarker, Stream<TabletLocationState> store) {
        this.context = context;
        this.fs = fs;
        this.useTrash = useTrash;
        this.liveServers = liveServers;
        this.walMarker = walMarker;
        this.store = store;
    }

    private static Stream<TabletLocationState> createStore(ServerContext context) {
        Stream rootStream = TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.ROOT, (ClientContext)context).stream();
        Stream metadataStream = TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.METADATA, (ClientContext)context).stream();
        Stream userStream = TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.USER, (ClientContext)context).stream();
        return (Stream)Streams.concat((Stream[])new Stream[]{rootStream, metadataStream, userStream}).onClose(() -> {
            try {
                rootStream.close();
            }
            finally {
                try {
                    metadataStream.close();
                }
                finally {
                    userStream.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collect(GCStatus status) {
        long removeStop;
        long logEntryScanStop;
        Map<UUID, TServerInstance> uuidToTServer;
        Set currentServers;
        long fileScanStop;
        long count;
        HashMap<UUID, Pair<WalStateManager.WalState, Path>> logsState;
        HashMap<TServerInstance, Set<UUID>> logsByServer;
        Map<UUID, Path> recoveryLogs;
        Preconditions.checkState((boolean)this.hasCollected.compareAndSet(false, true), (Object)"collect() has already been called on this object (which should only be called once)");
        try {
            Span span = TraceUtil.startSpan(this.getClass(), (String)"getCandidates");
            try (Scope scope = span.makeCurrent();){
                status.currentLog.started = System.currentTimeMillis();
                recoveryLogs = this.getSortedWALogs();
                logsByServer = new HashMap<TServerInstance, Set<UUID>>();
                logsState = new HashMap<UUID, Pair<WalStateManager.WalState, Path>>();
                count = this.getCurrent(logsByServer, logsState);
                fileScanStop = System.currentTimeMillis();
                log.info(String.format("Fetched %d files for %d servers in %.2f seconds", count, logsByServer.size(), (double)(fileScanStop - status.currentLog.started) / 1000.0));
                status.currentLog.candidates = count;
            }
            catch (Exception e) {
                TraceUtil.setException((Span)span, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                span.end();
            }
            this.liveServers.scanServers();
            currentServers = this.liveServers.getCurrentServers();
            Span span2 = TraceUtil.startSpan(this.getClass(), (String)"removeEntriesInUse");
            try (Scope scope = span2.makeCurrent();){
                uuidToTServer = this.removeEntriesInUse(logsByServer, currentServers, logsState, recoveryLogs);
                count = uuidToTServer.size();
            }
            catch (Exception ex) {
                log.error("Unable to scan metadata table", (Throwable)ex);
                TraceUtil.setException((Span)span2, (Throwable)ex, (boolean)false);
                status.currentLog.finished = System.currentTimeMillis();
                status.lastLog = status.currentLog;
                status.currentLog = new GcCycleStats();
                return;
            }
            logEntryScanStop = System.currentTimeMillis();
        }
        catch (Exception e) {
            log.error("exception occurred while garbage collecting write ahead logs", (Throwable)e);
            return;
        }
        log.info(String.format("%d log entries scanned in %.2f seconds", count, (double)(logEntryScanStop - fileScanStop) / 1000.0));
        Span span3 = TraceUtil.startSpan(this.getClass(), (String)"removeReplicationEntries");
        try (Scope scope = span3.makeCurrent();){
            count = this.removeReplicationEntries(uuidToTServer);
        }
        catch (Exception ex) {
            log.error("Unable to scan replication table", (Throwable)ex);
            TraceUtil.setException((Span)span3, (Throwable)ex, (boolean)false);
            status.currentLog.finished = System.currentTimeMillis();
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
            return;
        }
        long replicationEntryScanStop = System.currentTimeMillis();
        log.info(String.format("%d replication entries scanned in %.2f seconds", count, (double)(replicationEntryScanStop - logEntryScanStop) / 1000.0));
        Span span4 = TraceUtil.startSpan(this.getClass(), (String)"removeFiles");
        try (Scope scope = span4.makeCurrent();){
            logsState.keySet().retainAll(uuidToTServer.keySet());
            count = this.removeFiles(logsState.values(), status);
            removeStop = System.currentTimeMillis();
            log.info(String.format("%d total logs removed from %d servers in %.2f seconds", count, logsByServer.size(), (double)(removeStop - logEntryScanStop) / 1000.0));
            count = this.removeFiles(recoveryLogs.values());
            log.info("{} recovery logs removed", (Object)count);
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span4, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            span4.end();
        }
        Span span5 = TraceUtil.startSpan(this.getClass(), (String)"removeMarkers");
        try (Scope scope = span5.makeCurrent();){
            count = this.removeTabletServerMarkers(uuidToTServer, logsByServer, currentServers);
            long removeMarkersStop = System.currentTimeMillis();
            log.info(String.format("%d markers removed in %.2f seconds", count, (double)(removeMarkersStop - removeStop) / 1000.0));
            return;
        }
        catch (Exception e) {
            TraceUtil.setException((Span)span5, (Throwable)e, (boolean)true);
            throw e;
        }
        finally {
            status.currentLog.finished = System.currentTimeMillis();
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
        }
    }

    private long removeTabletServerMarkers(Map<UUID, TServerInstance> uidMap, Map<TServerInstance, Set<UUID>> candidates, Set<TServerInstance> liveServers) {
        long result = 0L;
        try {
            for (Map.Entry<UUID, TServerInstance> entry : uidMap.entrySet()) {
                this.walMarker.removeWalMarker(entry.getValue(), entry.getKey());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (Map.Entry<UUID, Object> entry : candidates.entrySet()) {
            if (liveServers.contains(entry.getKey())) continue;
            log.info("Removing znode for " + String.valueOf(entry.getKey()));
            try {
                this.walMarker.forget((TServerInstance)entry.getKey());
            }
            catch (WalStateManager.WalMarkerException ex) {
                log.info("Error removing znode for " + String.valueOf(entry.getKey()) + " " + String.valueOf((Object)ex));
            }
        }
        return result;
    }

    private Future<?> removeFile(ExecutorService deleteThreadPool, Path path, AtomicLong counter, String msg) {
        return deleteThreadPool.submit(() -> {
            try {
                log.debug(msg);
                if (!this.useTrash || !this.fs.moveToTrash(path)) {
                    this.fs.deleteRecursively(path);
                }
                counter.incrementAndGet();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ex) {
                log.error("Unable to delete {}", (Object)path, (Object)ex);
            }
        });
    }

    /*
     * Exception decompiling
     */
    private long removeFiles(Collection<Pair<WalStateManager.WalState, Path>> collection, GCStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long removeFiles(Collection<Path> values) {
        ThreadPoolExecutor deleteThreadPool = ThreadPools.getServerThreadPools().createExecutorService(this.context.getConfiguration(), Property.GC_DELETE_WAL_THREADS);
        HashMap futures = new HashMap(values.size());
        AtomicLong counter = new AtomicLong();
        try {
            for (Path path : values) {
                futures.put(path, this.removeFile(deleteThreadPool, path, counter, "Removing recovery log " + String.valueOf(path)));
            }
            while (!futures.isEmpty()) {
                Iterator iter = futures.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry f = iter.next();
                    if (!((Future)f.getValue()).isDone()) continue;
                    try {
                        iter.remove();
                        ((Future)f.getValue()).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException("Uncaught exception deleting recovery log file" + String.valueOf(f.getKey()), e);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while sleeping", e);
                    return counter.get();
                }
            }
        }
        finally {
            deleteThreadPool.shutdownNow();
        }
    }

    private UUID path2uuid(Path path) {
        return UUID.fromString(path.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<UUID, TServerInstance> removeEntriesInUse(Map<TServerInstance, Set<UUID>> candidates, Set<TServerInstance> liveServers, Map<UUID, Pair<WalStateManager.WalState, Path>> logsState, Map<UUID, Path> recoveryLogs) {
        HashMap<UUID, TServerInstance> result = new HashMap<UUID, TServerInstance>();
        for (Map.Entry<TServerInstance, Set<UUID>> entry : candidates.entrySet()) {
            for (UUID id : entry.getValue()) {
                if (result.put(id, entry.getKey()) == null) continue;
                throw new IllegalArgumentException("WAL " + String.valueOf(id) + " owned by multiple tservers");
            }
        }
        try {
            this.store.forEach(state -> {
                Set idsToIgnore;
                if (state.getState(liveServers) == TabletState.ASSIGNED_TO_DEAD_SERVER && (idsToIgnore = (Set)candidates.remove(state.current.getServerInstance())) != null) {
                    result.keySet().removeAll(idsToIgnore);
                    recoveryLogs.keySet().removeAll(idsToIgnore);
                }
                for (Collection wals : state.walogs) {
                    for (String wal : wals) {
                        UUID walUUID = this.path2uuid(new Path(wal));
                        TServerInstance dead = (TServerInstance)result.get(walUUID);
                        Set idsToIgnore2 = (Set)candidates.remove(dead);
                        if (idsToIgnore2 == null) continue;
                        result.keySet().removeAll(idsToIgnore2);
                        recoveryLogs.keySet().removeAll(idsToIgnore2);
                    }
                }
            });
        }
        finally {
            this.store.close();
        }
        for (TServerInstance liveServer : liveServers) {
            Set<UUID> idsForServer = candidates.get(liveServer);
            if (idsForServer == null) continue;
            for (UUID id : idsForServer) {
                Pair<WalStateManager.WalState, Path> stateFile = logsState.get(id);
                if (stateFile.getFirst() == WalStateManager.WalState.UNREFERENCED) continue;
                result.remove(id);
            }
            recoveryLogs.keySet().removeAll(idsForServer);
        }
        return result;
    }

    @Deprecated
    protected int removeReplicationEntries(Map<UUID, TServerInstance> candidates) {
        try {
            try {
                Scanner s = ReplicationTable.getScanner((AccumuloClient)this.context);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                for (Map.Entry entry : s) {
                    UUID id = this.path2uuid(new Path(((Key)entry.getKey()).getRow().toString()));
                    candidates.remove(id);
                    log.info("Ignore closed log " + String.valueOf(id) + " because it is being replicated");
                }
            }
            catch (ReplicationTableOfflineException ex) {
                return candidates.size();
            }
            Scanner scanner = this.context.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            scanner.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            scanner.setRange(MetadataSchema.ReplicationSection.getRange());
            for (Map.Entry entry : scanner) {
                Text file = new Text();
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                UUID id = this.path2uuid(new Path(file.toString()));
                candidates.remove(id);
                log.info("Ignore closed log " + String.valueOf(id) + " because it is being replicated");
            }
            return candidates.size();
        }
        catch (TableNotFoundException e) {
            log.error("Failed to scan metadata table", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    private long getCurrent(Map<TServerInstance, Set<UUID>> logsByServer, Map<UUID, Pair<WalStateManager.WalState, Path>> logState) throws Exception {
        long result = 0L;
        Map markers = this.walMarker.getAllMarkers();
        for (Map.Entry entry : markers.entrySet()) {
            HashSet<UUID> ids = new HashSet<UUID>(((List)entry.getValue()).size());
            for (UUID id : (List)entry.getValue()) {
                ids.add(id);
                logState.put(id, (Pair<WalStateManager.WalState, Path>)this.walMarker.state((TServerInstance)entry.getKey(), id));
                ++result;
            }
            logsByServer.put((TServerInstance)entry.getKey(), ids);
        }
        return result;
    }

    protected Map<UUID, Path> getSortedWALogs() throws IOException {
        HashMap<UUID, Path> result = new HashMap<UUID, Path>();
        for (String dir : this.context.getRecoveryDirs()) {
            Path recoveryDir = new Path(dir);
            if (!this.fs.exists(recoveryDir)) continue;
            for (FileStatus status : this.fs.listStatus(recoveryDir)) {
                try {
                    UUID logId = this.path2uuid(status.getPath());
                    result.put(logId, status.getPath());
                }
                catch (IllegalArgumentException iae) {
                    log.debug("Ignoring file " + String.valueOf(status.getPath()) + " because it doesn't look like a uuid");
                }
            }
        }
        return result;
    }
}

