/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.manager.state.MetaDataTableScanner;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindOfflineTablets {
    private static final Logger log = LoggerFactory.getLogger(FindOfflineTablets.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ServerUtilOpts opts = new ServerUtilOpts();
        opts.parseArgs(FindOfflineTablets.class.getName(), args, new Object[0]);
        Span span = TraceUtil.startSpan(FindOfflineTablets.class, (String)"main");
        try (Scope scope = span.makeCurrent();){
            ServerContext context = opts.getServerContext();
            FindOfflineTablets.findOffline(context, null);
        }
        finally {
            span.end();
        }
    }

    static int findOffline(ServerContext context, String tableName) throws TableNotFoundException {
        final AtomicBoolean scanning = new AtomicBoolean(false);
        LiveTServerSet tservers = new LiveTServerSet(context, new LiveTServerSet.Listener(){

            @Override
            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                if (!deleted.isEmpty() && scanning.get()) {
                    log.warn("Tablet servers deleted while scanning: {}", deleted);
                }
                if (!added.isEmpty() && scanning.get()) {
                    log.warn("Tablet servers added while scanning: {}", added);
                }
            }
        });
        tservers.startListeningForTabletServerChanges();
        scanning.set(true);
        Iterator zooScanner = TabletStateStore.getStoreForLevel(Ample.DataLevel.ROOT, context).iterator();
        int offline = 0;
        System.out.println("Scanning zookeeper");
        offline = FindOfflineTablets.checkTablets(context, zooScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if (Ample.DataLevel.METADATA.metaTable().equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning " + Ample.DataLevel.METADATA.metaTable());
        MetaDataTableScanner rootScanner = new MetaDataTableScanner(context, MetadataSchema.TabletsSection.getRange(), Ample.DataLevel.METADATA);
        offline = FindOfflineTablets.checkTablets(context, rootScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if (Ample.DataLevel.USER.metaTable().equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning " + Ample.DataLevel.USER.metaTable());
        Range range = MetadataSchema.TabletsSection.getRange();
        if (tableName != null) {
            TableId tableId = context.getTableId(tableName);
            range = new KeyExtent(tableId, null, null).toMetaRange();
        }
        try (MetaDataTableScanner metaScanner = new MetaDataTableScanner(context, range, Ample.DataLevel.USER);){
            int n = FindOfflineTablets.checkTablets(context, metaScanner, tservers);
            return n;
        }
    }

    private static int checkTablets(ServerContext context, Iterator<TabletLocationState> scanner, LiveTServerSet tservers) {
        int offline = 0;
        while (scanner.hasNext() && !System.out.checkError()) {
            TabletLocationState locationState = scanner.next();
            TabletState state = locationState.getState(tservers.getCurrentServers());
            if (state == null || state == TabletState.HOSTED || context.getTableManager().getTableState(locationState.extent.tableId()) == TableState.OFFLINE) continue;
            System.out.println(String.valueOf(locationState) + " is " + String.valueOf(state) + "  #walogs:" + locationState.walogs.size());
            ++offline;
        }
        return offline;
    }
}

